/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus.blobs;

import de.uni_bremen.st.rcf.persistence.bplus.blobs.Blob;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.Chunk;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.StringBlob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class BlobStore {
    private FileChannel fileChannel;
    private long nextPosition;

    public BlobStore(File file) throws IOException {
        this.fileChannel = this.createFileChannel(file);
        this.nextPosition = this.fileChannel.size();
    }

    public <T extends Blob> long appendBlob(T blob) throws IOException {
        long blobPosition = this.nextPosition;
        this.fileChannel.position(blobPosition);
        int size = blob.sizeBytes();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        blob.writeToByteBuffer(buffer);
        buffer.flip();
        this.fileChannel.write(buffer);
        this.nextPosition += (long)size;
        assert (this.nextPosition == this.fileChannel.position());
        assert (this.nextPosition == this.fileChannel.size());
        return blobPosition;
    }

    public <T extends Chunk> void readChunk(T chunk, long position) throws IOException {
        int size = chunk.sizeBytes();
        MappedByteBuffer buffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, position, size);
        chunk.readFromByteBuffer(buffer);
    }

    public <T extends Chunk> void writeChunk(T chunk, long position) throws IOException {
        int size = chunk.sizeBytes();
        MappedByteBuffer buffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, position, size);
        chunk.writeToByteBuffer(buffer);
    }

    public StringBlob readStringBlob(long position) throws IOException {
        long size;
        assert (this.nextPosition == this.fileChannel.size());
        if (position > this.nextPosition) {
            throw new RuntimeException("The position points past the end of the file. There is no StringBlob.");
        }
        long l = size = position + 4096L > this.nextPosition ? this.nextPosition - position : 4096L;
        assert (size <= 4096L);
        MappedByteBuffer buffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, position, size);
        StringBlob sblob = new StringBlob();
        sblob.readFromByteBuffer(buffer);
        return sblob;
    }

    private FileChannel createFileChannel(File file) throws FileNotFoundException {
        RandomAccessFile rad = new RandomAccessFile(file, "rw");
        return rad.getChannel();
    }
}

