/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus.blobs;

import de.uni_bremen.st.rcf.persistence.bplus.blobs.AbstractChunk;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BoolChunk
extends AbstractChunk {
    public boolean[] values;

    public BoolChunk(int numValues) {
        super(numValues);
        this.values = new boolean[numValues];
    }

    @Override
    protected int valuesArraySize() {
        return this.values.length;
    }

    @Override
    protected void writeValuesArray(ByteBuffer buffer) throws IOException {
        for (int i = 0; i < this.values.length; ++i) {
            buffer.put(this.values[i] ? (byte)1 : 0);
        }
    }

    @Override
    protected void readValuesArray(ByteBuffer buffer) throws IOException {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = buffer.get() != 0;
        }
    }

    @Override
    public void set(int index, boolean value) {
        int bound = Math.min(this.numUsed + 1, this.values.length);
        if (index >= bound) {
            throw new IndexOutOfBoundsException("Index is " + index + ", bound is " + bound);
        }
        this.values[index] = value;
        if (index == this.numUsed) {
            ++this.numUsed;
        }
    }

    @Override
    public boolean getBoolean(int index) {
        if (index >= this.numUsed) {
            throw new IndexOutOfBoundsException("Index is " + index + ", bound is " + this.values.length);
        }
        return this.values[index];
    }
}

