/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus.blobs;

import de.uni_bremen.st.rcf.persistence.bplus.blobs.AbstractChunk;
import java.io.IOException;
import java.nio.ByteBuffer;

public class IntChunk
extends AbstractChunk {
    public int[] values;

    public IntChunk(int numValues) {
        super(numValues);
        this.values = new int[numValues];
    }

    @Override
    protected int valuesArraySize() {
        return 4 * this.values.length;
    }

    @Override
    protected void writeValuesArray(ByteBuffer buffer) throws IOException {
        for (int i = 0; i < this.values.length; ++i) {
            buffer.putInt(this.values[i]);
        }
    }

    @Override
    protected void readValuesArray(ByteBuffer buffer) throws IOException {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = buffer.getInt();
        }
    }

    @Override
    public void set(int index, int value) {
        int bound = Math.min(this.numUsed + 1, this.values.length);
        if (index >= bound) {
            throw new IndexOutOfBoundsException("Index is " + index + ", bound is " + bound);
        }
        this.values[index] = value;
        if (index == this.numUsed) {
            ++this.numUsed;
        }
    }

    @Override
    public int getInt(int index) {
        if (index >= this.numUsed) {
            throw new IndexOutOfBoundsException("Index is " + index + ", bound is " + this.values.length);
        }
        return this.values[index];
    }
}

