/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus.tree;

import de.uni_bremen.st.rcf.persistence.bplus.ElementAlreadyExistsException;
import de.uni_bremen.st.rcf.persistence.bplus.ElementNotFoundException;
import de.uni_bremen.st.rcf.persistence.bplus.EmptyTreeException;
import de.uni_bremen.st.rcf.persistence.bplus.tree.BTreeNode;
import de.uni_bremen.st.rcf.persistence.bplus.tree.DataType;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Leaf
implements BTreeNode {
    int sizeBytes;
    boolean isLeaf = true;
    int numUsed;
    int[] keys;
    boolean[] booleanValues = null;
    float[] floatValues = null;
    int[] intValues = null;
    long[] longValues = null;
    long successor = -1L;

    private static int calculateSizeBytes(int capacity, DataType type) {
        int valueSize;
        int sizeBytes = 4;
        ++sizeBytes;
        sizeBytes += capacity * 4;
        switch (type) {
            case FLOAT: 
            case INTEGER: {
                valueSize = 4;
                break;
            }
            case BOOLEAN: {
                valueSize = 1;
                break;
            }
            case LONG: {
                valueSize = 8;
                break;
            }
            default: {
                throw new RuntimeException("Can't happen.");
            }
        }
        sizeBytes += capacity * valueSize;
        return sizeBytes += 8;
    }

    public static int calculateMaxSizeBytes(int capacity) {
        return Leaf.calculateSizeBytes(capacity, DataType.LONG);
    }

    Leaf(int capacity, DataType dataType) {
        this.keys = new int[capacity];
        switch (dataType) {
            case FLOAT: {
                this.floatValues = new float[capacity];
                break;
            }
            case INTEGER: {
                this.intValues = new int[capacity];
                break;
            }
            case BOOLEAN: {
                this.booleanValues = new boolean[capacity];
                break;
            }
            case LONG: {
                this.longValues = new long[capacity];
                break;
            }
            default: {
                throw new RuntimeException("Can't happen.");
            }
        }
        this.numUsed = 0;
        this.sizeBytes = Leaf.calculateSizeBytes(capacity, dataType);
    }

    int findInsertionPoint(int key) throws ElementAlreadyExistsException {
        int nip = Arrays.binarySearch(this.keys, 0, this.numUsed, key);
        if (nip >= 0) {
            assert (nip < this.numUsed);
            throw new ElementAlreadyExistsException(nip);
        }
        return -nip - 1;
    }

    int searchInt(int key) throws ElementNotFoundException {
        int pos = Arrays.binarySearch(this.keys, 0, this.numUsed, key);
        if (pos < 0) {
            throw new ElementNotFoundException(key);
        }
        return this.intValues[pos];
    }

    float searchFloat(int key) throws ElementNotFoundException {
        int pos = Arrays.binarySearch(this.keys, 0, this.numUsed, key);
        if (pos < 0) {
            throw new ElementNotFoundException(key);
        }
        return this.floatValues[pos];
    }

    boolean searchBoolean(int key) throws ElementNotFoundException {
        int pos = Arrays.binarySearch(this.keys, 0, this.numUsed, key);
        if (pos < 0) {
            throw new ElementNotFoundException(key);
        }
        return this.booleanValues[pos];
    }

    long searchLong(int key) throws ElementNotFoundException {
        int pos = Arrays.binarySearch(this.keys, 0, this.numUsed, key);
        if (pos < 0) {
            throw new ElementNotFoundException(key);
        }
        return this.longValues[pos];
    }

    public int getKeyAt(int index) {
        assert (index < this.numUsed);
        return this.keys[index];
    }

    void insert(int key, boolean value) {
        int ip;
        try {
            ip = this.findInsertionPoint(key);
        }
        catch (ElementAlreadyExistsException e) {
            this.booleanValues[e.getInsertionPoint()] = value;
            return;
        }
        for (int i = this.numUsed; i > ip; --i) {
            this.keys[i] = this.keys[i - 1];
            this.booleanValues[i] = this.booleanValues[i - 1];
        }
        this.keys[ip] = key;
        this.booleanValues[ip] = value;
        ++this.numUsed;
    }

    void insert(int key, float value) {
        int ip;
        try {
            ip = this.findInsertionPoint(key);
        }
        catch (ElementAlreadyExistsException e) {
            this.floatValues[e.getInsertionPoint()] = value;
            return;
        }
        for (int i = this.numUsed; i > ip; --i) {
            this.keys[i] = this.keys[i - 1];
            this.floatValues[i] = this.floatValues[i - 1];
        }
        this.keys[ip] = key;
        this.floatValues[ip] = value;
        ++this.numUsed;
    }

    void insert(int key, int value) {
        int ip;
        try {
            ip = this.findInsertionPoint(key);
        }
        catch (ElementAlreadyExistsException e) {
            this.intValues[e.getInsertionPoint()] = value;
            return;
        }
        for (int i = this.numUsed; i > ip; --i) {
            this.keys[i] = this.keys[i - 1];
            this.intValues[i] = this.intValues[i - 1];
        }
        this.keys[ip] = key;
        this.intValues[ip] = value;
        ++this.numUsed;
    }

    void insert(int key, long value) {
        int ip;
        try {
            ip = this.findInsertionPoint(key);
        }
        catch (ElementAlreadyExistsException e) {
            this.longValues[e.getInsertionPoint()] = value;
            return;
        }
        for (int i = this.numUsed; i > ip; --i) {
            this.keys[i] = this.keys[i - 1];
            this.longValues[i] = this.longValues[i - 1];
        }
        this.keys[ip] = key;
        this.longValues[ip] = value;
        ++this.numUsed;
    }

    boolean isFull() {
        return this.numUsed == this.keys.length;
    }

    public int getNumUsed() {
        return this.numUsed;
    }

    @Override
    public void writeToByteBuffer(ByteBuffer buffer) {
        int i;
        buffer.put(this.isLeaf ? (byte)1 : 0);
        buffer.putInt(this.numUsed);
        for (i = 0; i < this.keys.length; ++i) {
            buffer.putInt(this.keys[i]);
        }
        if (this.booleanValues != null) {
            for (i = 0; i < this.booleanValues.length; ++i) {
                buffer.put((byte)(this.booleanValues[i] ? 1 : 0));
            }
        } else if (this.floatValues != null) {
            for (i = 0; i < this.floatValues.length; ++i) {
                buffer.putFloat(this.floatValues[i]);
            }
        } else if (this.intValues != null) {
            for (i = 0; i < this.intValues.length; ++i) {
                buffer.putInt(this.intValues[i]);
            }
        } else if (this.longValues != null) {
            for (i = 0; i < this.longValues.length; ++i) {
                buffer.putLong(this.longValues[i]);
            }
        } else {
            throw new RuntimeException("This node does not contain data, so it should not be written.");
        }
        buffer.putLong(this.successor);
    }

    @Override
    public void loadFromByteBuffer(ByteBuffer buffer) {
        int i;
        byte isLeafByte = buffer.get();
        boolean bl = this.isLeaf = isLeafByte != 0;
        if (!this.isLeaf) {
            throw new RuntimeException("The thing at the current position of the buffer is no leaf. Check whether you pass a correctly configured buffer.");
        }
        this.numUsed = buffer.getInt();
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i] = buffer.getInt();
        }
        if (this.booleanValues != null) {
            for (i = 0; i < this.booleanValues.length; ++i) {
                byte bool = buffer.get();
                this.booleanValues[i] = bool != 0;
            }
        } else if (this.floatValues != null) {
            for (i = 0; i < this.floatValues.length; ++i) {
                this.floatValues[i] = buffer.getFloat();
            }
        } else if (this.intValues != null) {
            for (i = 0; i < this.intValues.length; ++i) {
                this.intValues[i] = buffer.getInt();
            }
        } else if (this.longValues != null) {
            for (i = 0; i < this.longValues.length; ++i) {
                this.longValues[i] = buffer.getLong();
            }
        } else {
            throw new RuntimeException("This node does not contain data, so it should not be written.");
        }
        this.successor = buffer.getLong();
    }

    public boolean checkKeyOrder() {
        boolean ordered = true;
        for (int i = 1; i <= this.numUsed; ++i) {
            ordered &= this.keys[i] > this.keys[i - 1];
        }
        return ordered;
    }

    public void split(Leaf right) {
        int i;
        int si = (this.keys.length - 1) / 2;
        for (i = si + 1; i < this.keys.length; ++i) {
            right.keys[i - si - 1] = this.keys[i];
        }
        if (this.booleanValues != null) {
            for (i = si + 1; i < this.keys.length; ++i) {
                right.booleanValues[i - si - 1] = this.booleanValues[i];
            }
        } else if (this.intValues != null) {
            for (i = si + 1; i < this.keys.length; ++i) {
                right.intValues[i - si - 1] = this.intValues[i];
            }
        } else if (this.longValues != null) {
            for (i = si + 1; i < this.keys.length; ++i) {
                right.longValues[i - si - 1] = this.longValues[i];
            }
        } else if (this.floatValues != null) {
            for (i = si + 1; i < this.keys.length; ++i) {
                right.floatValues[i - si - 1] = this.floatValues[i];
            }
        } else {
            throw new RuntimeException("This node does not contain any values. This is a bug.");
        }
        right.numUsed = this.keys.length - si - 1;
        this.numUsed = si + 1;
        right.successor = this.successor;
    }

    @Override
    public int sizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int smallestKey() {
        return this.keys[0];
    }

    @Override
    public int largestKey() throws EmptyTreeException {
        if (this.numUsed == 0) {
            throw new EmptyTreeException();
        }
        return this.keys[this.numUsed - 1];
    }

    public long getSuccessor() {
        return this.successor;
    }
}

