/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus.tree;

import de.uni_bremen.st.rcf.persistence.bplus.tree.BTreeNode;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Node
implements BTreeNode {
    int numUsed;
    int[] keys;
    long[] children;

    public static int calculateMaxSizeBytes(int capacity) {
        int sizeBytes = 1;
        sizeBytes += (capacity - 1) * 4;
        return sizeBytes += capacity * 8;
    }

    Node(int capacity) {
        this.keys = new int[capacity - 1];
        this.children = new long[capacity];
        this.numUsed = 0;
    }

    Node(int capacity, int key0, long pointer0, long pointer1) {
        this.keys = new int[capacity - 1];
        this.children = new long[capacity];
        this.numUsed = 2;
        this.keys[0] = key0;
        this.children[0] = pointer0;
        this.children[1] = pointer1;
    }

    boolean isFull() {
        return this.numUsed == this.children.length;
    }

    @Override
    public void writeToByteBuffer(ByteBuffer buffer) {
        int i;
        buffer.put((byte)0);
        buffer.putInt(this.numUsed);
        for (i = 0; i < this.keys.length; ++i) {
            buffer.putInt(this.keys[i]);
        }
        for (i = 0; i < this.children.length; ++i) {
            buffer.putLong(this.children[i]);
        }
    }

    @Override
    public void loadFromByteBuffer(ByteBuffer buffer) {
        int i;
        byte isLeafByte = buffer.get();
        if (isLeafByte != 0) {
            throw new RuntimeException("The thing at the current position of the buffer is no inner node. Check whether you pass a correctly configured buffer.");
        }
        this.numUsed = buffer.getInt();
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i] = buffer.getInt();
        }
        for (i = 0; i < this.children.length; ++i) {
            this.children[i] = buffer.getLong();
        }
    }

    @Override
    public int sizeBytes() {
        int size = 1;
        size += 4;
        size += this.keys.length * 4;
        return size += this.children.length * 8;
    }

    public long getChildPosition(int key) {
        if (key <= this.smallestKey()) {
            return this.children[0];
        }
        if (key > this.largestKey()) {
            return this.children[this.numUsed - 1];
        }
        int idx = Arrays.binarySearch(this.keys, 0, this.numUsed - 1, key);
        if (idx < 0) {
            idx = -idx - 1;
            assert (idx < this.numUsed);
        } else assert (this.keys[idx] == key);
        return this.children[idx];
    }

    public void insert(int key, long pointer) {
        int i;
        int numKeys = this.numUsed - 1;
        int ip = Arrays.binarySearch(this.keys, 0, numKeys, key);
        assert (ip < 0);
        ip = -ip - 1;
        for (i = numKeys; i > ip; --i) {
            this.keys[i] = this.keys[i - 1];
        }
        this.keys[ip] = key;
        for (i = this.numUsed; i > ip + 1; --i) {
            this.children[i] = this.children[i - 1];
        }
        this.children[ip + 1] = pointer;
        ++this.numUsed;
    }

    public int split(Node right) {
        int i;
        int numKeys = this.numUsed - 1;
        int si = numKeys / 2;
        int splitKey = this.keys[si];
        for (i = si + 1; i < numKeys; ++i) {
            right.keys[i - si - 1] = this.keys[i];
        }
        for (i = si + 1; i < this.numUsed; ++i) {
            right.children[i - si - 1] = this.children[i];
        }
        right.numUsed = this.numUsed / 2;
        this.numUsed -= right.numUsed;
        return splitKey;
    }

    @Override
    public int largestKey() {
        return this.keys[this.numUsed - 2];
    }

    @Override
    public int smallestKey() {
        return this.keys[0];
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

