/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.jdbm;

import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.IdAttributeBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.RCFBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.RelationBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;

public class AttributeBinding<T>
extends AbstractAttributeBinding {
    protected AttributeType type;
    protected int attributeId;
    private SortedMap<Integer, T> values;
    private SortedMap<Integer, int[]> intListValues = null;
    private SortedMap<Integer, boolean[]> booleanListValues = null;
    private SortedMap<Integer, float[]> floatListValues = null;
    private SortedMap<Integer, String[]> stringListValues = null;
    private final String name;
    private final boolean isEnum;
    private final boolean isList;
    private final List<String> enumValues;
    private final String referencedRelationName;

    protected AttributeBinding(String name, AttributeType type, int attributeId, boolean isList, boolean isEnum, List<String> enumValues, RelationBinding relation, String referencedRelationName) {
        super(name, relation);
        this.name = name;
        this.type = type;
        this.attributeId = attributeId;
        this.isList = isList;
        this.isEnum = isEnum;
        this.enumValues = enumValues;
        this.referencedRelationName = referencedRelationName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public boolean isEnum() {
        return this.isEnum;
    }

    @Override
    public List<String> getEnumValues() {
        return this.enumValues;
    }

    @Override
    public AbstractRelationBinding getReferencedRelation() {
        RCFBinding rcf = (RCFBinding)this.relation.getRcf();
        return rcf.getRelation(this.referencedRelationName);
    }

    public T getValue(Integer id) {
        assert (!this.isList);
        return (T)this.values.get(id);
    }

    public void setValue(Integer id, T value) {
        assert (!this.isList);
        this.values.put(id, value);
        if (!(this instanceof IdAttributeBinding)) {
            ((RelationBinding)this.relation).markSetInAttribute(id, this.attributeId);
        }
    }

    public void setList(Integer id, List<T> list) {
        assert (this.isList);
        int j = 0;
        switch (this.type) {
            case INTEGER: 
            case REFERENCE: {
                List<T> ilist = list;
                int[] iarray = new int[list.size()];
                Iterator<T> i$ = ilist.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    iarray[j++] = i;
                }
                this.setList(id, iarray);
                break;
            }
            case FLOAT: {
                List<T> flist = list;
                float[] farray = new float[list.size()];
                Iterator<T> i$ = flist.iterator();
                while (i$.hasNext()) {
                    float f = ((Float)i$.next()).floatValue();
                    farray[j++] = f;
                }
                this.setList(id, farray);
                break;
            }
            case BOOLEAN: {
                List<T> blist = list;
                boolean[] barray = new boolean[list.size()];
                Iterator<T> i$ = blist.iterator();
                while (i$.hasNext()) {
                    boolean b = (Boolean)i$.next();
                    barray[j++] = b;
                }
                this.setList(id, barray);
                break;
            }
            case STRING: {
                List<T> slist = list;
                String[] sarray = new String[list.size()];
                for (String s : slist) {
                    sarray[j++] = s;
                }
                this.setList(id, sarray);
                break;
            }
            default: {
                throw new RuntimeException("Can't happen.");
            }
        }
    }

    public void setList(Integer id, int[] list) {
        assert (this.isList);
        this.intListValues.put(id, list);
    }

    public void setList(Integer id, boolean[] list) {
        assert (this.isList);
        this.booleanListValues.put(id, list);
    }

    public void setList(Integer id, float[] list) {
        assert (this.isList);
        this.floatListValues.put(id, list);
    }

    public void setList(Integer id, String[] list) {
        assert (this.isList);
        this.stringListValues.put(id, list);
    }

    public boolean isSet(Integer id) {
        return ((RelationBinding)this.relation).isSetInAttribute(id, this.attributeId);
    }

    public void remove(Integer id) {
        block8: {
            block7: {
                if (!this.isList) break block7;
                switch (this.type) {
                    case INTEGER: 
                    case REFERENCE: {
                        this.intListValues.remove(id);
                        break block8;
                    }
                    case FLOAT: {
                        this.floatListValues.remove(id);
                        break block8;
                    }
                    case BOOLEAN: {
                        this.booleanListValues.remove(id);
                        break block8;
                    }
                    case STRING: {
                        this.stringListValues.remove(id);
                        break block8;
                    }
                    default: {
                        throw new RuntimeException("Can't happen.");
                    }
                }
            }
            this.values.remove(id);
        }
        if (!(this instanceof IdAttributeBinding)) {
            ((RelationBinding)this.relation).markUnsetInAttribute(id, this.attributeId);
        }
    }

    public List<T> getList(Integer key) {
        switch (this.type) {
            case INTEGER: 
            case REFERENCE: {
                return this.getIntList(key);
            }
            case FLOAT: {
                return this.getFloatList(key);
            }
            case BOOLEAN: {
                return this.getBooleanList(key);
            }
            case STRING: {
                return this.getStringList(key);
            }
        }
        throw new RuntimeException("Can't happen.");
    }

    private List<Integer> getIntList(Integer key) {
        assert (this.isList);
        int[] values = (int[])this.intListValues.get(key);
        ArrayList<Integer> valuesList = new ArrayList<Integer>(values.length);
        for (int i : values) {
            valuesList.add(i);
        }
        return valuesList;
    }

    private List<Float> getFloatList(Integer key) {
        assert (this.isList);
        float[] values = (float[])this.floatListValues.get(key);
        ArrayList<Float> valuesList = new ArrayList<Float>(values.length);
        for (float i : values) {
            valuesList.add(Float.valueOf(i));
        }
        return valuesList;
    }

    private List<Boolean> getBooleanList(Integer key) {
        assert (this.isList);
        boolean[] values = (boolean[])this.booleanListValues.get(key);
        ArrayList<Boolean> valuesList = new ArrayList<Boolean>(values.length);
        for (boolean i : values) {
            valuesList.add(i);
        }
        return valuesList;
    }

    private List<String> getStringList(Integer key) {
        ArrayList<String> valuesList;
        assert (this.isList);
        Object[] ovalues = (Object[])this.stringListValues.get(key);
        assert (ovalues != null);
        if (ovalues.length == 0) {
            valuesList = new ArrayList<String>();
        } else {
            String[] values = (String[])ovalues;
            valuesList = new ArrayList(values.length);
            for (String i : values) {
                valuesList.add(i);
            }
        }
        return valuesList;
    }

    protected void setValues(SortedMap<Integer, T> values) {
        this.values = values;
    }

    protected Integer lastKey() {
        if (!this.isList) {
            return this.values.lastKey();
        }
        switch (this.type) {
            case INTEGER: 
            case REFERENCE: {
                return this.intListValues.lastKey();
            }
            case BOOLEAN: {
                return this.booleanListValues.lastKey();
            }
            case FLOAT: {
                return this.floatListValues.lastKey();
            }
            case STRING: {
                return this.stringListValues.lastKey();
            }
        }
        throw new RuntimeException("Can't happen.");
    }

    protected int size() {
        if (this.isList) {
            if (this.intListValues != null) {
                return this.intListValues.size();
            }
            if (this.floatListValues != null) {
                return this.floatListValues.size();
            }
            if (this.stringListValues != null) {
                return this.stringListValues.size();
            }
            if (this.booleanListValues != null) {
                return this.booleanListValues.size();
            }
        }
        return this.values.size();
    }

    protected Iterator<T> iterator() {
        assert (!this.isList);
        return this.values.values().iterator();
    }

    protected void createList(int id) {
        switch (this.type) {
            case INTEGER: 
            case REFERENCE: {
                int[] ilist = new int[]{};
                this.setList((Integer)id, ilist);
                break;
            }
            case FLOAT: {
                float[] flist = new float[]{};
                this.setList((Integer)id, flist);
                break;
            }
            case BOOLEAN: {
                boolean[] blist = new boolean[]{};
                this.setList((Integer)id, blist);
                break;
            }
            case STRING: {
                String[] slist = new String[]{};
                this.setList((Integer)id, slist);
                break;
            }
            default: {
                throw new RuntimeException("Can't happen.");
            }
        }
        ((RelationBinding)this.relation).markSetInAttribute(id, this.attributeId);
    }

    protected void setIntListValues(SortedMap<Integer, int[]> intListValues) {
        this.intListValues = intListValues;
    }

    protected void setFloatListValues(SortedMap<Integer, float[]> floatListValues) {
        this.floatListValues = floatListValues;
    }

    protected void setBooleanListValues(SortedMap<Integer, boolean[]> booleanListValues) {
        this.booleanListValues = booleanListValues;
    }

    protected void setStringListValues(SortedMap<Integer, String[]> stringListValues) {
        this.stringListValues = stringListValues;
    }

    protected boolean valuesContainsKey(Integer id) {
        return this.values.containsKey(id);
    }

    protected Iterator<Integer> valuesKeyIterator() {
        return this.values.keySet().iterator();
    }

    void addIfNotExisting(Integer id) {
        assert (this.type == AttributeType.INTEGER);
        if (!this.values.containsKey(id)) {
            this.values.put(id, 0);
        }
    }
}

