/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.jdbm;

import de.uni_bremen.st.rcf.exceptions.RelationExistsException;
import de.uni_bremen.st.rcf.persistence.AbstractRCFBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.Caching;
import de.uni_bremen.st.rcf.persistence.jdbm.JDBMAttributeType;
import de.uni_bremen.st.rcf.persistence.jdbm.RelationBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kotek.jdbm.DB;
import net.kotek.jdbm.DBMaker;

public class RCFBinding
extends AbstractRCFBinding {
    final File file;
    final DB db;
    private Map<String, RelationBinding> relationBindingRefs = new HashMap<String, RelationBinding>();
    protected Set<String> relations;
    private Map<String, String[]> attributes;
    protected Map<String, JDBMAttributeType> types;

    public RCFBinding(File file, Caching caching) {
        this.file = file;
        DBMaker dbMaker = new DBMaker(file.getAbsolutePath());
        switch (caching) {
            case NONE: {
                dbMaker.disableCache();
                break;
            }
            case WEAK: {
                dbMaker.enableWeakCache();
                break;
            }
            case SOFT: {
                dbMaker.enableSoftCache();
                break;
            }
            case HARD: {
                dbMaker.enableHardCache();
                break;
            }
            case MRU: {
                dbMaker.enableMRUCache();
                break;
            }
            default: {
                throw new RuntimeException("Can't happen.");
            }
        }
        dbMaker.disableTransactions();
        this.db = dbMaker.build();
        try {
            this.loadSchema();
        }
        catch (IllegalArgumentException e) {
            this.createSchema();
        }
    }

    private void loadSchema() throws IllegalArgumentException {
        this.relations = this.db.getHashSet("relations");
        this.attributes = this.db.getHashMap("attributes");
        this.types = this.db.getHashMap("types");
    }

    private void createSchema() {
        this.relations = this.db.createHashSet("relations");
        this.attributes = this.db.createHashMap("attributes");
        this.types = this.db.createHashMap("types");
    }

    @Override
    public AbstractRelationBinding addRelation(String name) {
        if (!this.relations.add(name)) {
            throw new RelationExistsException();
        }
        this.attributes.put(name, new String[0]);
        RelationBinding binding = new RelationBinding(this, name, null);
        this.relationBindingRefs.put(name, binding);
        binding.addAttribute("id", AttributeType.INTEGER, false, false, null, new String[0]);
        return binding;
    }

    @Override
    public AbstractRelationBinding getRelation(String name) {
        if (!this.relations.contains(name)) {
            return null;
        }
        return this.loadRelationBinding(name);
    }

    @Override
    public List<AbstractRelationBinding> getRelations() {
        ArrayList<AbstractRelationBinding> relationBindings = new ArrayList<AbstractRelationBinding>();
        for (String relationName : this.relations) {
            relationBindings.add(this.loadRelationBinding(relationName));
        }
        return relationBindings;
    }

    @Override
    public boolean hasRelation(String name) {
        return this.relations.contains(name);
    }

    @Override
    public void save() {
        this.db.commit();
    }

    @Override
    public void saveAs(File f) {
        throw new UnsupportedOperationException("Create a new RCF and copy all contents.");
    }

    @Override
    public void close() {
        this.db.commit();
        this.db.close();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    private RelationBinding loadRelationBinding(String name) {
        RelationBinding binding = this.relationBindingRefs.get(name);
        if (binding == null) {
            List<String> an;
            Object[] attrNamesO = this.attributes.get(name);
            if (!(attrNamesO instanceof String[])) {
                an = new ArrayList<String>(attrNamesO.length);
                for (int i = 0; i < attrNamesO.length; ++i) {
                    assert (attrNamesO[i] instanceof String);
                    an.add(i, (String)attrNamesO[i]);
                }
            } else {
                an = Arrays.asList((String[])attrNamesO);
            }
            binding = new RelationBinding(this, name, an);
            this.relationBindingRefs.put(name, binding);
        }
        return binding;
    }

    protected void addAttributeName(String relationName, String attributeName) {
        String[] attrs0;
        Object[] attrs0o = this.attributes.get(relationName);
        assert (attrs0o != null);
        if (!(attrs0o instanceof String[])) {
            attrs0 = new String[attrs0o.length];
            for (int i = 0; i < attrs0o.length; ++i) {
                assert (attrs0o[i] instanceof String);
                attrs0[i] = (String)attrs0o[i];
            }
        } else {
            attrs0 = (String[])attrs0o;
        }
        String[] attrs1 = Arrays.copyOf(attrs0, attrs0.length + 1);
        attrs1[attrs0.length] = attributeName;
        this.attributes.put(relationName, attrs1);
    }
}

