/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.schema;

import de.uni_bremen.st.rcf.schema.AttributeType;
import de.uni_bremen.st.rcf.schema.RelationPOJO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AttributePOJO {
    private String name;
    private AttributeType type;
    private boolean isEnum = false;
    private boolean isList = false;
    private boolean cached = false;
    private RelationPOJO referencedRelation = null;
    private final List<String> enumValues;

    protected AttributePOJO() {
        this.enumValues = new ArrayList<String>();
    }

    protected AttributePOJO(String name, AttributeType type, boolean isEnum, boolean isList, RelationPOJO referencedRelation, String ... enumValues) {
        this.name = name;
        this.type = type;
        this.isEnum = isEnum;
        this.isList = isList;
        this.referencedRelation = referencedRelation;
        this.enumValues = new ArrayList<String>();
        Collections.addAll(this.enumValues, enumValues);
        this.checkEnumValues();
    }

    private void checkEnumValues() {
        for (String value : this.enumValues) {
            for (String otherValue : this.enumValues) {
                if (value == otherValue || !value.equals(otherValue)) continue;
                throw new RuntimeException("Got a non-distinct set of enum values!");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public AttributeType getType() {
        return this.type;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isList() {
        return this.isList;
    }

    public RelationPOJO getReferencedRelation() {
        return this.referencedRelation;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(AttributeType type) {
        this.type = type;
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    public void setReferencedRelation(RelationPOJO referencedRelation) {
        this.referencedRelation = referencedRelation;
    }

    protected void addEnumValue(String enumValue) {
        this.enumValues.add(enumValue);
        this.checkEnumValues();
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }
}

