/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.model.Versions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class FileVersionHandler {
    private static final int CACHE_SIZE = 100;
    private static final String SEPERATOR = File.separator;
    private static FileVersionHandler instance;
    private final Map<String, String> cache = new LinkedHashMap<String, String>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 100;
        }
    };
    private final List<Version> versions = new ArrayList<Version>();

    private FileVersionHandler() {
    }

    public static synchronized FileVersionHandler getInstance() {
        if (null == instance) {
            instance = new FileVersionHandler();
        }
        return instance;
    }

    public String getLastValidFile(Fragment fragment) throws FileNotFoundException {
        return this.getLastValidFile(fragment.getStart().getFile());
    }

    public String getLastValidFile(SourcePosition sourcePosition) throws FileNotFoundException {
        return this.getLastValidFile(sourcePosition.getFile());
    }

    public String getLastValidFile(de.uni_bremen.st.rcf.model.File file) throws FileNotFoundException {
        String absolutePath = file.getAbsolutePath();
        String validPath = this.cache.get(absolutePath);
        if (null == validPath) {
            if (this.checkFile(absolutePath)) {
                validPath = absolutePath;
            } else {
                Version currentVersion = file.getVersion();
                int idxOfLastVersion = this.versions.indexOf(currentVersion);
                if (-1 == idxOfLastVersion) {
                    throw new FileNotFoundException("Version " + this.getVersion(currentVersion) + " is unknown");
                }
                List<Version> validVersions = this.copyList(this.versions.subList(0, idxOfLastVersion));
                Collections.reverse(validVersions);
                for (Version v : validVersions) {
                    String tmpPath = this.stripFilePathToVersion(file, this.getVersion(v));
                    if (!this.checkFile(tmpPath)) continue;
                    validPath = tmpPath;
                }
            }
            if (null == validPath) {
                throw new FileNotFoundException("Unable to calculate last valid path for file: " + file.getAbsolutePath());
            }
            this.cache.put(absolutePath, validPath);
        }
        return validPath;
    }

    public void setRCF(RCF rcf) {
        this.versions.clear();
        this.cache.clear();
        Versions versionsOfRCF = rcf.getVersions();
        for (int i = 1; i <= versionsOfRCF.size(); ++i) {
            this.versions.add((Version)versionsOfRCF.getEntry(i));
        }
    }

    private List<Version> copyList(List<Version> versions) {
        ArrayList<Version> copy = new ArrayList<Version>(versions.size());
        for (Version v : versions) {
            copy.add(v);
        }
        return copy;
    }

    private boolean checkFile(String file) {
        return this.checkFile(new File(file));
    }

    private boolean checkFile(File file) {
        return file.exists() && file.canRead();
    }

    private String getVersion(Version version) {
        String result;
        Scanner scanner = new Scanner(version.getBasepath());
        scanner.useDelimiter(SEPERATOR);
        do {
            result = scanner.next();
        } while (scanner.hasNext());
        return result;
    }

    private String stripFilePathToVersion(de.uni_bremen.st.rcf.model.File file, String version) {
        String basePath = this.removeLastDirectory(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - file.getRelativePath().length()));
        return basePath + SEPERATOR + version + SEPERATOR + file.getRelativePath();
    }

    private String removeLastDirectory(String path) {
        if (path.endsWith(SEPERATOR)) {
            path = path.substring(0, path.length() - SEPERATOR.length());
        }
        return path.substring(0, path.lastIndexOf(SEPERATOR));
    }
}

