/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.Metadata;
import de.uni_bremen.st.rcf.model.Metadatas;
import de.uni_bremen.st.rcf.model.ProcessData;
import de.uni_bremen.st.rcf.model.ProcessDatas;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MetadataOutput {
    private static int lineWidth = 135;
    private static PrintStream out = System.out;

    private static String times(String s, int times) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    private static void printLine() {
        out.println(MetadataOutput.times("-", lineWidth));
    }

    private static String cellValue(String text) {
        return MetadataOutput.cellValue(text, 10);
    }

    private static String cellValue(String text, int width) {
        if (text == null || text.equals("?")) {
            return MetadataOutput.times(" ", width - 1) + "?";
        }
        if (text.length() > width) {
            return text.substring(0, width);
        }
        if (text.length() > 0 && Character.isDigit(text.charAt(0))) {
            return MetadataOutput.times(" ", width - text.length()) + text;
        }
        return text + MetadataOutput.times(" ", width - text.length());
    }

    private static String makeSpace(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 30 - s.length(); ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static void printAttributes(List<Attribute> attribs, ProcessData pd) {
        MetadataOutput.printAttributes(attribs, pd, 0);
    }

    private static String getAsString(Entry e, Attribute a) {
        if (e.isSet(a)) {
            switch (a.getType()) {
                case INTEGER: {
                    return Integer.toString(e.getInt(a));
                }
                case FLOAT: {
                    return Float.toString(e.getFloat(a));
                }
                case STRING: {
                    return e.getString(a);
                }
                case BOOLEAN: {
                    return Boolean.toString(e.getBool(a));
                }
            }
        }
        return "";
    }

    private static void printAttributes(List<Attribute> attribs, ProcessData pd, int nesting) {
        boolean hasValues = false;
        StringBuffer sb = new StringBuffer();
        sb.append(MetadataOutput.times(" ", nesting));
        sb.append("Phase '");
        sb.append(pd.getPhaseName());
        sb.append("':\n");
        for (Attribute a : attribs) {
            String aName = a.getName();
            if (!pd.isSet(a) || aName.equals("children") || aName.equals("id") || aName.equals("phase_name")) continue;
            hasValues = true;
            sb.append(MetadataOutput.times(" ", nesting + 5));
            sb.append(aName);
            sb.append(":");
            sb.append(MetadataOutput.makeSpace(aName));
            sb.append(MetadataOutput.getAsString(pd, a));
            sb.append("\n");
        }
        if (hasValues || pd.getChildren().size() > 0) {
            out.print(sb.toString());
        }
        for (ProcessData child : pd.getChildren()) {
            MetadataOutput.printAttributes(attribs, child, nesting + 5);
        }
    }

    private static ArrayList<Attribute> collectAttributes(Relation<?> rel) {
        String[] keys = new String[]{"description", "totalReal", "childrenReal", "selfReal", "totalCpu", "childrenCpu", "selfCpu", "memStart", "memEnd"};
        ArrayList<Attribute> attribs = new ArrayList<Attribute>(keys.length);
        for (String key : keys) {
            if (rel.hasAttribute(key)) {
                attribs.add(rel.getAttribute(key));
                continue;
            }
            System.err.format("Attribute %s not present!\n", key);
        }
        return attribs;
    }

    private static void printTiming(ArrayList<Attribute> attribs, ProcessData pd) {
        MetadataOutput.printTiming(attribs, pd, 0);
    }

    private static void printTiming(ArrayList<Attribute> attribs, ProcessData pd, int nesting) {
        out.format("|%s", MetadataOutput.cellValue(MetadataOutput.times(" ", nesting) + pd.getPhaseName(), 24));
        for (Attribute a : attribs) {
            out.format("|%s", MetadataOutput.cellValue(pd.isSet(a) ? pd.getString(a) : "?", a.getName().equals("description") ? 20 : 10));
        }
        out.println("|");
        for (ProcessData child : pd.getChildren()) {
            MetadataOutput.printTiming(attribs, child, nesting + 2);
        }
    }

    static void printMetaData(RCF rcf) {
        Metadatas metadata = rcf.getMetadatas();
        ProcessDatas processdata = rcf.getProcessDatas();
        MetadataOutput.printLine();
        out.format("Printing Metadata for RCF file %s\n", rcf.getFile().getName());
        MetadataOutput.printLine();
        String cmdName = "";
        StringBuffer args = new StringBuffer();
        TreeMap<String, String> others = new TreeMap<String, String>();
        for (Metadata md : metadata) {
            if (md.getKey().equals("command-name")) {
                cmdName = md.getValue();
                continue;
            }
            if (md.getKey().startsWith("argument-")) {
                args.append(md.getValue());
                args.append(" ");
                continue;
            }
            others.put(md.getKey(), md.getValue());
        }
        out.format("Command:%s%s %s", MetadataOutput.makeSpace("Command"), cmdName, args.toString());
        for (Map.Entry o : others.entrySet()) {
            out.format("%s:%s%s\n", o.getKey(), MetadataOutput.makeSpace((String)o.getKey()), o.getValue());
        }
        List<Attribute> attribs = processdata.getAttributes();
        MetadataOutput.printAttributes(attribs, (ProcessData)processdata.getFirstEntry());
        MetadataOutput.printLine();
        out.format("|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|\n", MetadataOutput.cellValue("phase", 24), MetadataOutput.cellValue("description", 20), MetadataOutput.cellValue("total_real"), MetadataOutput.cellValue("children_real"), MetadataOutput.cellValue("self_real"), MetadataOutput.cellValue("total_cpu"), MetadataOutput.cellValue("children_cpu"), MetadataOutput.cellValue("self_cpu"), MetadataOutput.cellValue("mem_start"), MetadataOutput.cellValue("mem_end"));
        MetadataOutput.printLine();
        for (ProcessData pd : processdata) {
            MetadataOutput.printTiming(MetadataOutput.collectAttributes(processdata), pd);
        }
    }
}

