/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Version;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jline.console.ConsoleReader;

public class ModifyBasepath {
    private RCF rcf;
    private ConsoleReader cr;
    private static final String MODE_DIALOG = "What do you want to do today?\n   1. Change a single version's basepath.\n   2. Change all basepaths using search & replace.\n   3. Save & Exit.\n   4. Exit without saving.";

    public static void modifyInteractive(RCF rcf) throws Exception {
        ModifyBasepath mb = new ModifyBasepath(rcf);
        mb.interactive();
    }

    private ModifyBasepath(RCF rcf) {
        assert (rcf != null);
        this.rcf = rcf;
    }

    private void interactive() throws Exception {
        this.cr = new ConsoleReader();
        this.cr.setPrompt("> ");
        this.printModeDialog();
        this.cr.getTerminal().restore();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printModeDialog() throws IOException {
        System.out.println(MODE_DIALOG);
        String input;
        while ((input = this.cr.readLine("> ")) != null) {
            if (input.length() == 1) {
                switch (input.charAt(0)) {
                    case '1': {
                        Pattern p;
                        Version v = this.queryVersion();
                        if (v == null || (p = this.queryChangeRegex()) == null) break;
                        this.replace(v, p, this.queryReplaceString());
                        break;
                    }
                    case '2': {
                        System.out.format("This allows you to search & replace over all version's basepaths in the rcf.\n", new Object[0]);
                        System.out.format("The basepath of the first version is:\n\t\"%s\"\n", ((Version)this.rcf.getVersions().getFirstEntry()).getBasepath());
                        Pattern p = this.queryChangeRegex();
                        if (p == null) break;
                        int changed = 0;
                        int unchanged = 0;
                        String r = this.queryReplaceString();
                        for (Version v : this.rcf.getVersions()) {
                            if (this.replace(v, p, r)) {
                                ++changed;
                                continue;
                            }
                            ++unchanged;
                        }
                        System.out.format("Replaced \"%s\" with \"%s\" in all versions:\n", p.toString(), r);
                        System.out.format("    unchanged basepaths: %d\n", unchanged);
                        System.out.format("    changed basepaths:   %d\n", changed);
                        System.out.format("... do not forget to save in next screen.\n", new Object[0]);
                        break;
                    }
                    case '3': {
                        this.rcf.save();
                    }
                    case '4': {
                        return;
                    }
                }
            }
            System.out.println(MODE_DIALOG);
        }
        return;
    }

    private boolean replace(Version v, Pattern p, String r) {
        String bp = v.getBasepath();
        String nbp = p.matcher(bp).replaceAll(r);
        System.out.format("new basepath of version %d is: \"%s\"\n", v.getId(), nbp);
        v.setBasepath(nbp);
        return !bp.equals(nbp);
    }

    private void printVersionList() {
        for (Version v : this.rcf.getVersions()) {
            System.out.format("%4d \"%s\"\n", v.getId(), v.getBasepath());
        }
    }

    private Version queryVersion() throws IOException {
        this.printVersionList();
        String vIdStr = this.cr.readLine("Choose a version/basepath to change: ");
        try {
            int vId = Integer.parseInt(vIdStr);
            return (Version)this.rcf.getVersions().getEntry(vId);
        }
        catch (NumberFormatException nfe) {
            System.out.format("Cannot find version \"%s\"!\n", vIdStr);
            return null;
        }
    }

    private Pattern queryChangeRegex() throws IOException {
        String regexStr;
        while ((regexStr = this.cr.readLine("Enter string to replace (leave empty to skip): ")) != null && regexStr.length() != 0) {
            try {
                return Pattern.compile(regexStr);
            }
            catch (PatternSyntaxException pse) {
                System.out.println(pse.getMessage());
                System.out.println(pse.getDescription());
            }
        }
        return null;
    }

    private String queryReplaceString() throws IOException {
        return this.cr.readLine("Enter the replacement string: ");
    }
}

