/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.schema.AttributeType;
import de.uni_bremen.st.rcf.util.XMLUtils;
import java.util.HashMap;

public class XMLSchemaWriter
extends XMLUtils {
    private final RCF rcf;
    private final boolean makeXMLDeclatation;

    public XMLSchemaWriter(RCF rcf, boolean makeXMLDeclatation) {
        this.rcf = rcf;
        this.makeXMLDeclatation = makeXMLDeclatation;
        if (makeXMLDeclatation) {
            this.makePrologue();
        }
        this.makeRCFDeclaration();
    }

    public String getSchemaString() {
        return this.getXMLString();
    }

    private String makeRCFDeclaration() {
        if (this.makeXMLDeclatation) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("version", "2.1");
            this.makeOpeningXMLTag("rcf", attributes, true);
        }
        for (Relation<Entry> rel : this.rcf.getRelations()) {
            this.getStringBuilder().append('\n');
            this.makeRelationDeclaration(rel);
        }
        if (this.makeXMLDeclatation) {
            this.makeClosingXMLTag("rcf", true);
        }
        return this.getStringBuilder().toString();
    }

    private void makeRelationDeclaration(Relation<Entry> rel) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", rel.getName());
        this.makeOpeningXMLTag("relation", attributes, true);
        for (Attribute att : rel.getAttributes()) {
            this.makeAttributeDeclaration(att);
        }
        this.makeClosingXMLTag("relation", true);
    }

    private void makeAttributeDeclaration(Attribute att) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", att.getName());
        attributes.put("type", att.getType().name().toLowerCase());
        if (att.isList()) {
            attributes.put("isList", "yes");
        }
        if (att.getType() == AttributeType.REFERENCE) {
            attributes.put("refRelation", att.getReferencedRelation().getName());
        }
        if (att.isEnum()) {
            this.makeOpeningXMLTag("attr", attributes, true);
            for (String ev : att.getEnumValues()) {
                this.getIndent();
                this.getStringBuilder().append("<enumValue>");
                this.getStringBuilder().append(ev.toUpperCase());
                this.getStringBuilder().append("</enumValue>\n");
            }
            this.makeClosingXMLTag("attr", true);
        } else {
            this.makeSimpleXMLTag("attr", attributes);
        }
    }
}

