/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util.rcfdiff;

import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.util.rcfdiff.Edge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class EntriesMapping<T extends Entry> {
    private HashMap<T, List<Edge<T>>> left = new HashMap();
    private HashMap<T, List<Edge<T>>> right = new HashMap();

    public void addExactMatch(T left, T right) {
        this.addMatch(new Edge<T>(left, right));
    }

    public void addNearMatch(T left, T right, int distance) {
        this.addMatch(new Edge<T>(left, right, distance));
    }

    private void addMatch(Edge<T> edge) {
        if (edge.distance == 0) {
            this.removeMappings(this.left, edge.left);
            this.removeMappings(this.right, edge.right);
        }
        this.add(this.left, edge.left, edge);
        this.add(this.right, edge.right, edge);
    }

    private void removeMappings(HashMap<T, List<Edge<T>>> map, T key) {
        List<Edge<T>> list = map.get(key);
        if (list != null) {
            Iterator<Edge<T>> iter = list.iterator();
            while (iter.hasNext()) {
                Edge<T> edge = iter.next();
                if (((Entry)edge.left).equals(key)) {
                    this.removeEdge(this.right, edge, edge.right);
                } else {
                    this.removeEdge(this.left, edge, edge.left);
                }
                iter.remove();
            }
        }
    }

    private void removeEdge(HashMap<T, List<Edge<T>>> map, Edge<T> edge, T key) {
        List<Edge<T>> list = map.get(key);
        if (list != null) {
            list.remove(edge);
        }
    }

    private void add(HashMap<T, List<Edge<T>>> map, T key, Edge<T> edge) {
        List<Edge<T>> list = map.get(key);
        if (list == null) {
            list = new ArrayList<Edge<T>>();
            map.put(key, list);
        }
        if (!list.contains(edge)) {
            list.add(edge);
        }
    }

    public HashMap<T, List<Edge<T>>> getLeft() {
        return this.left;
    }

    public HashMap<T, List<Edge<T>>> getRight() {
        return this.right;
    }

    public void deleteInvalidMappings() {
        this.deleteInvalidMappings(this.left);
        this.deleteInvalidMappings(this.right);
        this.deleteEmptyMappings(this.left);
        this.deleteEmptyMappings(this.right);
    }

    private void deleteEmptyMappings(HashMap<T, List<Edge<T>>> map) {
        Iterator<List<Edge<T>>> iter = map.values().iterator();
        while (iter.hasNext()) {
            List<Edge<T>> list = iter.next();
            if (!list.isEmpty()) continue;
            iter.remove();
        }
    }

    private void deleteInvalidMappings(HashMap<T, List<Edge<T>>> map) {
        for (List<Edge<T>> list : map.values()) {
            int bestDistance = Integer.MAX_VALUE;
            for (Edge<T> edge : list) {
                if ((bestDistance = Math.min(edge.distance, bestDistance)) != 0) continue;
                break;
            }
            Iterator<Edge<T>> iter = list.iterator();
            while (iter.hasNext()) {
                Edge<T> edge;
                edge = iter.next();
                if (edge.distance <= bestDistance) continue;
                iter.remove();
            }
        }
    }
}

