/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer;

import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcfviewer.RCFViewerMenuBar;
import de.uni_bremen.st.rcfviewer.controller.CloneClassCtrl;
import de.uni_bremen.st.rcfviewer.controller.ClonePairCtrl;
import de.uni_bremen.st.rcfviewer.controller.ConsoleCtrl;
import de.uni_bremen.st.rcfviewer.controller.Ctrl;
import de.uni_bremen.st.rcfviewer.controller.FileRatiosCtrl;
import de.uni_bremen.st.rcfviewer.controller.RcfRelationCtrl;
import de.uni_bremen.st.rcfviewer.controller.VersionCtrl;
import de.uni_bremen.st.rcfviewer.dialogs.MainDialogs;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.KnightRiderProgressDialog;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker.OffsetWorker;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFEventAdapter;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFWrapper;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionEvent;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionListener;
import de.uni_bremen.st.rcfviewer.views.TabViewDisposeListener;
import de.uni_bremen.st.rcfviewer.views.View;
import de.uni_bremen.st.rcfviewer.views.cloneview.CloneView;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class RCFMainWindow
extends RCFEventAdapter {
    private static final String TITLE_PREFIX = "jrcfviewer";
    private RCFWrapper rcf;
    private Display display;
    private Shell shell;
    private TabFolder top;
    private Map<String, CloneView> topItems = new TreeMap<String, CloneView>();
    private TabFolder bottom;
    private Map<String, TabItem> bottomTabs = new HashMap<String, TabItem>();
    private Map<String, Ctrl<? extends View>> bottomController = new TreeMap<String, Ctrl<? extends View>>();
    private Set<String> defaultBottomItems = new TreeSet<String>();
    private ConsoleCtrl consoleCtrl;
    private CloneClassCtrl ccCtrl;
    private RcfRelationCtrl versionCtrl;
    private ClonePairCtrl cpCtrl;
    private FileRatiosCtrl filesCtrl;
    private CloneView cloneView;
    private static RCFMainWindow instance;

    public RCFMainWindow() {
        this.rcf = RCFWrapper.getInstance();
        instance = this;
        try {
            File tmpRCFFile = this.createTempFile();
            this.rcf.createTmp(tmpRCFFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Fatal: Could not generate temp file", e);
        }
        this.initComponents();
    }

    public RcfRelationCtrl getVersionCtrl() {
        return this.versionCtrl;
    }

    public RcfRelationCtrl getClonePairCtrl() {
        return this.cpCtrl;
    }

    public CloneClassCtrl getCloneClassCtrl() {
        return this.ccCtrl;
    }

    public FileRatiosCtrl getFilesCtrl() {
        return this.filesCtrl;
    }

    public ConsoleCtrl getConsoleCtrl() {
        return this.consoleCtrl;
    }

    public Shell getShell() {
        return this.shell;
    }

    public CloneView getCloneView() {
        return this.cloneView;
    }

    public static RCFMainWindow getInstance() {
        return instance;
    }

    public void open() {
        try {
            this.open(null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void open(String rcfFile) throws FileNotFoundException {
        this.shell.pack();
        this.shell.setMaximized(true);
        this.shell.open();
        if (null != rcfFile) {
            this.rcf.loadRCF(rcfFile);
        }
        while (!this.shell.isDisposed()) {
            if (!this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    public final boolean dispose() throws CancellationException {
        boolean saved = MainDialogs.showSaveDialog();
        this.shell.dispose();
        return saved;
    }

    public TabItem addTopItem(String name, CloneView view) {
        if (this.topItems.containsKey(name)) {
            return null;
        }
        TabItem item = new TabItem(this.top, 0);
        item.setText(name);
        item.setControl(view.getControl());
        this.top.layout();
        this.topItems.put(name, view);
        return item;
    }

    public TabItem addBottomItem(String name, Ctrl<? extends View> ctrl) {
        TabItem tabItem;
        if (!this.bottomController.containsKey(name)) {
            View view = ctrl.makeView((Composite)this.bottom);
            tabItem = new TabItem(this.bottom, 0);
            tabItem.setText(name);
            tabItem.setControl(view.getControl());
            this.bottomTabs.put(name, tabItem);
            this.bottom.layout();
            this.bottomController.put(name, ctrl);
            view.addDisposeListener(new TabViewDisposeListener(name){

                @Override
                public void viewDisposed() {
                    RCFMainWindow.this.removeBottomItem(this.name);
                }
            });
        } else {
            tabItem = this.bottomTabs.get(name);
        }
        return tabItem;
    }

    private void removeBottomItem(String name) {
        if (!this.defaultBottomItems.contains(name) && this.bottomTabs.containsKey(name)) {
            TabItem selected = this.bottom.getSelection()[0];
            this.bottom.setSelection(0);
            this.bottomController.remove(name);
            this.bottomTabs.get(name).dispose();
            this.bottomTabs.remove(name);
            if (!selected.isDisposed()) {
                this.bottom.setSelection(selected);
            }
        }
    }

    public void setBottomSelection(int i) {
        this.bottom.setSelection(i);
    }

    public void setBottomSelection(TabItem tabItem) {
        this.bottom.setSelection(tabItem);
    }

    private File createTempFile() throws IOException {
        return File.createTempFile("rcfviewer", ".rcf");
    }

    private void initComponents() {
        this.rcf.addRCFListener(this);
        this.defaultBottomItems.add("Clone Classes");
        this.defaultBottomItems.add("Clone Pairs");
        this.defaultBottomItems.add("Versions");
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setText(TITLE_PREFIX);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                try {
                    RCFMainWindow.this.dispose();
                }
                catch (CancellationException e) {
                    event.doit = false;
                }
            }
        });
        new RCFViewerMenuBar(this, this.rcf);
        SashForm sash = new SashForm((Composite)this.shell, 66048);
        this.top = new TabFolder((Composite)sash, 128);
        this.bottom = new TabFolder((Composite)sash, 1024);
        this.bottom.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                TabItem tabItem;
                if (mouseEvent.button == 2 && null != (tabItem = RCFMainWindow.this.bottom.getItem(new Point(mouseEvent.x, mouseEvent.y))) && !RCFMainWindow.this.defaultBottomItems.contains(tabItem.getText())) {
                    ((Ctrl)RCFMainWindow.this.bottomController.get(tabItem.getText())).dispose();
                }
            }
        });
        this.cloneView = new CloneView((Composite)this.top);
        this.addTopItem("Clone View", this.cloneView);
        this.ccCtrl = new CloneClassCtrl();
        this.addBottomItem("Clone Classes", this.ccCtrl);
        this.ccCtrl.addCloneClassSelectionListener(new SelectionListener<CloneClass>(){

            @Override
            public void handleEvent(SelectionEvent<CloneClass> e) {
                CloneClass selection = e.getSelection();
                List<Fragment> l = selection.getFragments();
                RCFMainWindow.this.cloneView.setLastLeftFragment(l.get(0));
            }
        });
        this.ccCtrl.addFragmentSelectionListener(new SelectionListener<Fragment>(){

            @Override
            public void handleEvent(SelectionEvent<Fragment> e) {
                RCFMainWindow.this.cloneView.setRight(e.getSelection());
            }
        });
        this.ccCtrl.getCloneClassCtrl().getModel().setSelection(0);
        this.cpCtrl = new ClonePairCtrl();
        TabItem cpTab = this.addBottomItem("Clone Pairs", this.cpCtrl);
        if (this.cpCtrl.getModel().getDataLength() > 0) {
            cpTab.getParent().setSelection(cpTab);
        }
        this.versionCtrl = new VersionCtrl();
        this.addBottomItem("Versions", this.versionCtrl);
        this.versionCtrl.setSelection(0);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                RCFMainWindow.this.shell.update();
            }
        });
    }

    @Override
    public void handleRCFLoad(RCF rcf) {
        this.shell.setText("jrcfviewer: " + rcf.getFile().getName());
    }

    @Override
    public void handleRCFImported(RCF rcf) {
        this.shell.setText(TITLE_PREFIX);
    }

    @Override
    public void handleVersionChange(Version version) {
        OffsetWorker ow = new OffsetWorker(version);
        KnightRiderProgressDialog pd = new KnightRiderProgressDialog("Calculating lines and clomns", ow, false);
        pd.open();
    }
}

