/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer;

import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcfviewer.RCFMainWindow;
import de.uni_bremen.st.rcfviewer.controller.FileRatiosCtrl;
import de.uni_bremen.st.rcfviewer.dialogs.MainDialogs;
import de.uni_bremen.st.rcfviewer.dialogs.ViewRelationSelectDialog;
import de.uni_bremen.st.rcfviewer.dialogs.imports.CCFImportDialog;
import de.uni_bremen.st.rcfviewer.dialogs.imports.CCFXImportDialog;
import de.uni_bremen.st.rcfviewer.dialogs.imports.CPDImportDialog;
import de.uni_bremen.st.rcfviewer.dialogs.imports.CPFImportDialog;
import de.uni_bremen.st.rcfviewer.dialogs.imports.SimianImportDialog;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFEventAdapter;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFWrapper;
import de.uni_bremen.st.rcfviewer.util.Config;
import de.uni_bremen.st.rcfviewer.views.cloneview.CloneView;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class RCFViewerMenuBar
extends RCFEventAdapter {
    private final Shell shell;
    private final RCFMainWindow parent;
    private final RCFWrapper rcf;
    private static final String RECENT_FILES_STRING = "rcfviewer.recentFiles";
    private static final int MAX_NUMBER_OF_RECENT_FILES = 4;
    private List<MenuItem> recentFiles = new LinkedList<MenuItem>();
    private MenuItem menuItemFile;
    private MenuItem menuItemOptions;
    private MenuItem menuItemFileSave;
    private MenuItem menuItemFileSaveAs;
    private MenuItem menuItemViewShowSimilarFiles;
    private MenuItem menuItemViewShowRel;

    public RCFViewerMenuBar(RCFMainWindow parent, RCFWrapper rcfWrapper) {
        this.shell = parent.getShell();
        this.parent = parent;
        this.rcf = rcfWrapper;
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        this.initialize(menu);
        this.rcf.addRCFListener(this);
    }

    private void initialize(Menu menu) {
        this.initFileMenu(menu);
        this.initViewMenu(menu);
        this.initOptionsMenu(menu);
    }

    private void initFileMenu(Menu menu) {
        this.menuItemFile = new MenuItem(menu, 64);
        this.menuItemFile.setText("&File");
        Menu menuFile = new Menu(menu);
        MenuItem menuItemFileOpen = new MenuItem(menuFile, 8);
        menuItemFileOpen.setText("&Open \tctrl+o");
        menuItemFileOpen.setAccelerator(SWT.MOD1 + 111);
        menuItemFileOpen.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                String filename = MainDialogs.showOpenRCFDialog();
                if (filename != null) {
                    try {
                        MainDialogs.showSaveDialog();
                        RCFViewerMenuBar.this.rcf.loadRCF(filename);
                        RCFViewerMenuBar.this.addRecentFile(filename);
                    }
                    catch (IOException io) {
                        MainDialogs.showErrorMessage("An error occurred while loading file: " + filename);
                    }
                    catch (CancellationException cancellationException) {
                        // empty catch block
                    }
                }
            }
        });
        MenuItem menuItemImport = new MenuItem(menuFile, 64);
        menuItemImport.setText("&Import");
        Menu importSubMenu = new Menu((Decorations)this.shell, 4);
        menuItemImport.setMenu(importSubMenu);
        final Shell parentShell = this.parent.getShell();
        MenuItem menuItemImportCCF = new MenuItem(importSubMenu, 8);
        menuItemImportCCF.setText("from CC&F");
        menuItemImportCCF.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    MainDialogs.showSaveDialog();
                    new CCFImportDialog(parentShell).open();
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
        });
        MenuItem menuItemImportCPD = new MenuItem(importSubMenu, 8);
        menuItemImportCPD.setText("from CP&D");
        menuItemImportCPD.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    MainDialogs.showSaveDialog();
                    new CPDImportDialog(parentShell).open();
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
        });
        MenuItem menuItemImportCPF = new MenuItem(importSubMenu, 8);
        menuItemImportCPF.setText("from C&PF");
        menuItemImportCPF.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    MainDialogs.showSaveDialog();
                    new CPFImportDialog(parentShell).open();
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
        });
        MenuItem menuItemImportCCFX = new MenuItem(importSubMenu, 8);
        menuItemImportCCFX.setText("from CCF&X");
        menuItemImportCCFX.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    MainDialogs.showSaveDialog();
                    new CCFXImportDialog(parentShell).open();
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
        });
        MenuItem menuItemImportSimian = new MenuItem(importSubMenu, 8);
        menuItemImportSimian.setText("from &Simian");
        menuItemImportSimian.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    MainDialogs.showSaveDialog();
                    new SimianImportDialog(parentShell).open();
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
        });
        this.menuItemFileSave = new MenuItem(menuFile, 8);
        this.menuItemFileSave.setText("&Save");
        this.menuItemFileSave.setEnabled(false);
        this.menuItemFileSave.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RCFViewerMenuBar.this.rcf.save();
            }
        });
        this.menuItemFileSaveAs = new MenuItem(menuFile, 8);
        this.menuItemFileSaveAs.setText("Save &As...");
        this.menuItemFileSaveAs.setEnabled(false);
        this.menuItemFileSaveAs.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainDialogs.showSaveAsDialog();
            }
        });
        new MenuItem(menuFile, 2);
        MenuItem menuItemFileExit = new MenuItem(menuFile, 8);
        menuItemFileExit.setText("E&xit");
        menuItemFileExit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    RCFViewerMenuBar.this.parent.dispose();
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
        });
        new MenuItem(menuFile, 2);
        MenuItem menuItemFileClearRecent = new MenuItem(menuFile, 8);
        menuItemFileClearRecent.setText("&Clear Recent Files");
        menuItemFileClearRecent.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RCFViewerMenuBar.this.clearRecentFiles();
            }
        });
        new MenuItem(menuFile, 2);
        this.menuItemFile.setMenu(menuFile);
        this.updateRecentFileMenu();
    }

    private void initViewMenu(Menu menu) {
        MenuItem menuItemView = new MenuItem(menu, 64);
        menuItemView.setText("&View");
        Menu menuView = new Menu(menu);
        this.menuItemViewShowRel = new MenuItem(menuView, 8);
        this.menuItemViewShowRel.setText("&Show Relation...");
        this.menuItemViewShowRel.setEnabled(false);
        this.menuItemViewShowRel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                new ViewRelationSelectDialog(RCFViewerMenuBar.this.parent).open();
            }
        });
        this.menuItemViewShowSimilarFiles = new MenuItem(menuView, 8);
        this.menuItemViewShowSimilarFiles.setText("Show Similar &Files");
        this.menuItemViewShowSimilarFiles.setEnabled(false);
        this.menuItemViewShowSimilarFiles.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                FileRatiosCtrl ctrl = FileRatiosCtrl.create();
                RCFViewerMenuBar.this.parent.setBottomSelection(RCFViewerMenuBar.this.parent.addBottomItem("Files", ctrl));
                ctrl.update();
            }
        });
        menuItemView.setMenu(menuView);
    }

    private void initOptionsMenu(Menu menu) {
        this.menuItemOptions = new MenuItem(menu, 64);
        this.menuItemOptions.setText("&Options");
        Menu menuOptions = new Menu(this.menuItemOptions);
        MenuItem paral = new MenuItem(menuOptions, 32);
        paral.setText("Scroll parallel");
        paral.setSelection(true);
        paral.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CloneView cw;
                cw.setScrollParallel(!(cw = RCFViewerMenuBar.this.parent.getCloneView()).isScrollParallel());
            }
        });
        MenuItem displayVis = new MenuItem(menuOptions, 32);
        displayVis.setText("Display only visible Connections");
        displayVis.setSelection(true);
        displayVis.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                CloneView cw;
                cw.setDrawOnlyVisibleConnectionEndpoints(!(cw = RCFViewerMenuBar.this.parent.getCloneView()).isDrawOnlyVisibleConnectionEndpoints());
                cw.redrawConnections();
            }
        });
        this.menuItemOptions.setMenu(menuOptions);
    }

    private void updateRecentFileMenu() {
        for (MenuItem item : this.recentFiles) {
            item.dispose();
        }
        this.recentFiles.clear();
        String files = Config.getConfig().getProperty(RECENT_FILES_STRING);
        if (files != null) {
            String[] fs;
            for (final String file : fs = files.split(File.pathSeparator)) {
                if (file.isEmpty()) continue;
                MenuItem item = new MenuItem(this.menuItemFile.getMenu(), 64);
                item.setText(file);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        try {
                            MainDialogs.showSaveDialog();
                            RCFViewerMenuBar.this.rcf.loadRCF(file);
                            RCFViewerMenuBar.this.addRecentFile(file);
                        }
                        catch (FileNotFoundException fnfe) {
                            MainDialogs.showErrorMessage("File: " + file + " not found");
                        }
                        catch (CancellationException cancellationException) {
                            // empty catch block
                        }
                    }
                });
                this.recentFiles.add(item);
            }
        }
    }

    public void addRecentFile(String filename) {
        String[] fs;
        this.removeRecentFile(filename);
        String files = Config.getConfig().getProperty(RECENT_FILES_STRING);
        if (files != null && (fs = files.split(File.pathSeparator)).length >= 4) {
            files = "";
            int n = 0;
            boolean first = true;
            StringBuilder stringBuilder = new StringBuilder(files);
            for (String file : fs) {
                if (++n == 4) break;
                if (file.isEmpty()) continue;
                if (first) {
                    first = false;
                } else {
                    files = files + File.pathSeparator;
                }
                stringBuilder.append(file);
            }
            files = stringBuilder.toString();
        }
        if (files != null && !files.isEmpty()) {
            if (!files.contains(filename)) {
                files = filename + File.pathSeparator + files;
            }
        } else {
            files = filename;
        }
        Config.getConfig().setProperty(RECENT_FILES_STRING, files);
        Config.saveConfig();
        this.updateRecentFileMenu();
    }

    public void removeRecentFile(String filename) {
        String files = Config.getConfig().getProperty(RECENT_FILES_STRING);
        if (files != null) {
            StringBuilder s = new StringBuilder();
            String[] fs = files.split(File.pathSeparator);
            boolean first = true;
            for (String file : fs) {
                if (file.equals(filename)) continue;
                if (first) {
                    first = false;
                } else {
                    s.append(File.pathSeparator);
                }
                s.append(file);
            }
            Config.getConfig().setProperty(RECENT_FILES_STRING, s.toString());
            Config.saveConfig();
        }
    }

    public void clearRecentFiles() {
        Config.getConfig().setProperty(RECENT_FILES_STRING, "");
        Config.saveConfig();
        this.updateRecentFileMenu();
    }

    @Override
    public void handleRCFLoad(RCF rcf) {
        this.menuItemViewShowSimilarFiles.setEnabled(true);
        this.menuItemViewShowRel.setEnabled(true);
        this.menuItemFileSaveAs.setEnabled(true);
        this.menuItemFileSave.setEnabled(true);
        this.addRecentFile(rcf.getFile().getAbsolutePath());
    }

    @Override
    public void handleRCFImported(RCF rcf) {
        this.menuItemViewShowSimilarFiles.setEnabled(true);
        this.menuItemViewShowRel.setEnabled(true);
        this.menuItemFileSaveAs.setEnabled(true);
        this.menuItemFileSave.setEnabled(false);
    }

    @Override
    public void handleRCFChange() {
        this.menuItemFileSave.setEnabled(true);
    }

    @Override
    public void handleRCFSave() {
        this.menuItemFileSave.setEnabled(false);
    }
}

