/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer;

import de.uni_bremen.st.rcfviewer.RCFMainWindow;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URISyntaxException;

public class Viewer {
    public static final boolean DEBUG = true;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: rcfviewer RCFFILE");
        }
        Viewer.copySWTJar();
        RCFMainWindow mainWindow = new RCFMainWindow();
        if (args.length > 0) {
            try {
                mainWindow.open(args[0]);
            }
            catch (FileNotFoundException e) {
                System.out.println("File " + args[0] + " does not exist!");
                System.exit(0);
            }
        } else {
            mainWindow.open();
        }
    }

    public static void copySWTJar() {
        int j;
        int i;
        String swtJar = "swt.jar";
        String classpath = System.getProperty("java.class.path");
        File dest = new File(classpath.substring((i = classpath.lastIndexOf(File.pathSeparatorChar, j = classpath.indexOf("swt.jar"))) + 1, j + 7));
        if (!dest.exists()) {
            System.out.println("> The file '" + dest.getAbsolutePath() + "' does not exist.");
            System.out.println("> This is probably the first time you start rcfviewer.");
            String architecture = System.getProperty("os.arch");
            String os = System.getProperty("os.name");
            String jarName = "";
            try {
                File myJar = new File(Viewer.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                jarName = myJar.getParent() + File.separator;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            jarName = jarName + "swt" + File.separator + "swt";
            jarName = jarName + "-debug";
            if (os.equals("Linux")) {
                jarName = jarName + "-linux";
                System.out.println("> You appear to be using Linux.");
            } else if (os.toLowerCase().contains("win")) {
                jarName = jarName + "-windows";
                System.out.println("> You appear to be using Windows.");
            } else {
                jarName = jarName + "-macosx";
                System.out.println("> You appear to be using a Mac.");
            }
            int bit = architecture.contains("64") ? 64 : 32;
            System.out.println("> You seem to be running a " + bit + "-Bit Java virtual machine.");
            jarName = jarName + "-" + bit;
            jarName = jarName + ".jar";
            File source = new File(jarName);
            System.out.println("> I'll try to copy '" + source.getAbsolutePath() + "' to '" + dest.getAbsolutePath() + ".");
            try {
                FileInputStream fis = new FileInputStream(source);
                FileOutputStream fos = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                int n = 0;
                while ((n = fis.read(buf)) != -1) {
                    fos.write(buf, 0, n);
                }
                fis.close();
                fos.close();
                System.out.println("> Copying was successful. If, however, my guesses were wrong, you may manually copy the correct JAR from '" + source.getParent() + File.separatorChar + "' to '" + dest.getParent() + File.separatorChar + "'. Ensure that it is named 'swt.jar'.");
            }
            catch (Exception e) {
                System.out.println("> For some reason I cannot copy the file. You may try to manually copy the correct JAR from '" + source.getParent() + File.separatorChar + "' to '" + dest.getParent() + File.separatorChar + "'. Ensure that it is named 'swt.jar'.");
            }
        }
    }
}

