/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.controller;

import de.uni_bremen.st.rcf.exceptions.ValueNotSetException;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcfviewer.RCFMainWindow;
import de.uni_bremen.st.rcfviewer.controller.Ctrl;
import de.uni_bremen.st.rcfviewer.controller.RcfRelationCtrl;
import de.uni_bremen.st.rcfviewer.models.CloneClassModel;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFWrapper;
import de.uni_bremen.st.rcfviewer.util.ColumnInfo;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.ColRenderer;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.DefaultColRenderer;
import de.uni_bremen.st.rcfviewer.util.filter.IdRowFilter;
import de.uni_bremen.st.rcfviewer.util.filter.VersionRowFilter;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionEvent;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionListener;
import de.uni_bremen.st.rcfviewer.views.CloneClassView;
import java.util.LinkedList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CloneClassCtrl
extends Ctrl<CloneClassView> {
    private CloneClassModel model;
    private CloneClassView view;
    private RcfRelationCtrl ccCtrl;
    private RcfRelationCtrl fCtrl;
    private IdRowFilter fragmentRowFilter;
    private VersionRowFilter cloneClassRowFilter;
    private RCFWrapper rcfWrapper = RCFWrapper.getInstance();

    public CloneClassCtrl() {
        this.model = new CloneClassModel();
        this.ccCtrl = new RcfRelationCtrl("CloneClass");
        ColumnInfo columnInfoId = new ColumnInfo(RcfRelationCtrl.getLabelForAttribute("id"), "id");
        columnInfoId.setActive(true);
        columnInfoId.setMinWidth(4);
        this.ccCtrl.addColumn(columnInfoId);
        this.ccCtrl.addColumn("clientId");
        this.ccCtrl.setActive(RcfRelationCtrl.getLabelForAttribute("clientId"), false);
        ColumnInfo columnInfoType = new ColumnInfo(RcfRelationCtrl.getLabelForAttribute("type"), "type");
        columnInfoType.setActive(true);
        columnInfoType.setMinWidth(7);
        this.ccCtrl.addColumn(columnInfoType);
        ColumnInfo columnInfoFragments = new ColumnInfo("#Fragments", "fragments", new ColRenderer(){

            @Override
            public String getText(Attribute a, Entry gt) {
                return this.getCompImage(a, gt).toString();
            }

            @Override
            public Comparable getCompImage(Attribute a, Entry gt) {
                String name = a.getName();
                if (!gt.isSet(name) || !a.isList()) {
                    return "?no fragment list?";
                }
                return Integer.valueOf(gt.getEntryList(a).size());
            }
        });
        columnInfoFragments.setMinWidth(15);
        this.ccCtrl.addColumn(columnInfoFragments);
        ColumnInfo ciLOC = new ColumnInfo("Size (LOC)", "fragments", new ColRenderer(){

            @Override
            public String getText(Attribute a, Entry gt) {
                Comparable c = this.getCompImage(a, gt);
                if (c.compareTo(-1) != 0) {
                    return this.getCompImage(a, gt).toString();
                }
                return "-";
            }

            @Override
            public Comparable getCompImage(Attribute a, Entry gt) {
                String name = a.getName();
                if (!gt.isSet(name) || !a.isList()) {
                    return "?no fragment list?";
                }
                if (gt instanceof CloneClass) {
                    int loc = 0;
                    CloneClass cc = (CloneClass)gt;
                    for (Fragment f : cc.getFragments()) {
                        try {
                            loc += f.getEnd().getLine() - f.getStart().getLine();
                        }
                        catch (ValueNotSetException e) {
                            loc += 0;
                        }
                    }
                    return Integer.valueOf(loc);
                }
                return Integer.valueOf(-1);
            }
        });
        this.ccCtrl.addColumn(ciLOC);
        this.cloneClassRowFilter = new VersionRowFilter(this.rcfWrapper.getVersion());
        this.ccCtrl.setRowFilter(this.cloneClassRowFilter);
        this.ccCtrl.addSelectionListener(new SelectionListener<Entry>(){

            @Override
            public void handleEvent(SelectionEvent e) {
                LinkedList<Integer> ids = new LinkedList<Integer>();
                if (e.getSelection() instanceof CloneClass) {
                    CloneClass cc = (CloneClass)e.getSelection();
                    for (Fragment f : cc.getFragments()) {
                        ids.add(f.getId());
                    }
                    CloneClassCtrl.this.setCloneClassSelection(cc);
                }
                CloneClassCtrl.this.fragmentRowFilter.setEnabledIds(ids);
                CloneClassCtrl.this.fCtrl.setRowFilter(CloneClassCtrl.this.fragmentRowFilter);
                CloneClassCtrl.this.fCtrl.update();
                CloneClassCtrl.this.fCtrl.setSelection(1);
            }
        });
        this.fCtrl = new RcfRelationCtrl("Fragment");
        this.fragmentRowFilter = new IdRowFilter();
        this.fCtrl.setRowFilter(this.fragmentRowFilter);
        this.fCtrl.addColumn("id");
        ColumnInfo columnInfoFile = new ColumnInfo("File", "file", new DefaultColRenderer(){

            @Override
            public String getText(Attribute a, Entry gt) {
                if (gt instanceof Fragment) {
                    File f = ((Fragment)gt).getStart().getFile();
                    return f.getRelativePath();
                }
                return "?no file?";
            }
        });
        this.fCtrl.addColumn(columnInfoFile);
        this.fCtrl.setActive(RcfRelationCtrl.getLabelForAttribute("clientId"), false);
        this.fCtrl.addAllColumns();
        this.fCtrl.removeColumn("clonePairs");
        this.fCtrl.removeColumn("cloneClasses");
        this.fCtrl.removeColumn("cloneClasses");
        this.fCtrl.removeColumn("start");
        this.fCtrl.removeColumn("end");
        this.fCtrl.setActive("predecessors", false);
        this.fCtrl.setActive("successors", false);
        ColumnInfo ciStart = new ColumnInfo("Start", new ColRenderer(){

            @Override
            public Comparable getCompImage(Attribute a, Entry gt) {
                try {
                    return Integer.valueOf(((Fragment)gt).getStart().getLine());
                }
                catch (RuntimeException e) {
                    return Integer.valueOf(-1);
                }
            }

            @Override
            public String getText(Attribute a, Entry gt) {
                String line = "-";
                String column = "-";
                if (gt instanceof Fragment) {
                    SourcePosition sourcePosition = ((Fragment)gt).getStart();
                    if (sourcePosition.isLineSet()) {
                        line = String.valueOf(sourcePosition.getLine());
                    }
                    if (sourcePosition.isColumnSet()) {
                        column = String.valueOf(sourcePosition.getColumn());
                    }
                }
                return String.format("%s:%s", line, column);
            }
        });
        this.fCtrl.addColumn(ciStart);
        ColumnInfo ciEnd = new ColumnInfo("End", new ColRenderer(){

            @Override
            public Comparable getCompImage(Attribute a, Entry gt) {
                try {
                    return Integer.valueOf(((Fragment)gt).getEnd().getLine());
                }
                catch (RuntimeException e) {
                    return Integer.valueOf(-1);
                }
            }

            @Override
            public String getText(Attribute a, Entry gt) {
                String line = "-";
                String column = "-";
                if (gt instanceof Fragment) {
                    SourcePosition sourcePosition = ((Fragment)gt).getEnd();
                    if (sourcePosition.isLineSet()) {
                        line = String.valueOf(sourcePosition.getLine());
                    }
                    if (sourcePosition.isColumnSet()) {
                        column = String.valueOf(sourcePosition.getColumn());
                    }
                }
                return String.format("%s:%s", line, column);
            }
        });
        this.fCtrl.addColumn(ciEnd);
        ColumnInfo ciNrOfLines = new ColumnInfo("#Lines", new ColRenderer(){

            @Override
            public Comparable getCompImage(Attribute a, Entry gt) {
                try {
                    Fragment fragment = (Fragment)gt;
                    return Integer.valueOf(fragment.getEnd().getLine() - fragment.getStart().getLine() + 1);
                }
                catch (RuntimeException e) {
                    return Integer.valueOf(0);
                }
            }

            @Override
            public String getText(Attribute a, Entry gt) {
                return this.getCompImage(a, gt).toString();
            }
        });
        this.fCtrl.addColumn(ciNrOfLines);
        this.fCtrl.addSelectionListener(new SelectionListener<Entry>(){

            @Override
            public void handleEvent(SelectionEvent e) {
                if (e.getSelection() instanceof Fragment) {
                    CloneClassCtrl.this.setFragmentSelection((Fragment)e.getSelection());
                }
            }
        });
        this.rcfWrapper.removeRCFListener(this.ccCtrl);
        this.rcfWrapper.removeRCFListener(this.fCtrl);
    }

    @Override
    public CloneClassView makeView(Composite parent) {
        if (this.view != null) {
            this.view.dispose();
        }
        this.view = new CloneClassView(parent, this.model, this);
        this.view.update();
        this.fCtrl.getView().getTable().addListener(35, new Listener(){

            public void handleEvent(Event arg0) {
                Menu menu = new Menu((Decorations)CloneClassCtrl.this.fCtrl.getView().getTable().getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setText("Set Left");
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        Fragment selection = (Fragment)CloneClassCtrl.this.fCtrl.getModel().getSelection();
                        RCFMainWindow.getInstance().getCloneView().setLastLeftFragment(selection);
                        RCFMainWindow.getInstance().getCloneView().setRight(selection);
                    }
                });
                menu.setVisible(true);
            }
        });
        return this.view;
    }

    public RcfRelationCtrl getCloneClassCtrl() {
        return this.ccCtrl;
    }

    public RcfRelationCtrl getFileCtrl() {
        return this.fCtrl;
    }

    public void setCloneClassSelection(CloneClass selection) {
        this.model.setSelectedCloneClass(selection);
    }

    public void setFragmentSelection(Fragment selection) {
        this.model.setSelectedFragment(selection);
    }

    public void update() {
        this.ccCtrl.getView().getControl().update();
        this.fCtrl.getView().getControl().update();
    }

    public void addCloneClassSelectionListener(SelectionListener<CloneClass> listener) {
        this.model.addCloneClassSelectionListener(listener);
    }

    public void removeCloneClassSelectionListener(SelectionListener<CloneClass> listener) {
        this.model.removeCloneClassSelectionListener(listener);
    }

    public void addFragmentSelectionListener(SelectionListener<Fragment> listener) {
        this.model.addFragmentSelectionListener(listener);
    }

    public void removeFragmentSelectionListener(SelectionListener<Fragment> listener) {
        this.model.removeFragmentSelectionListener(listener);
    }

    @Override
    public void handleRCFLoad(RCF rcf) {
        if (this.ccCtrl.getModel().getDataLength() > 0) {
            this.ccCtrl.setSelection(0);
        }
    }

    @Override
    public void handleVersionChange(Version version) {
        this.model.setVersion(version);
        this.cloneClassRowFilter.setVersion(version);
        this.ccCtrl.setRowFilter(this.cloneClassRowFilter);
        this.view.update();
        if (this.ccCtrl.getModel().getDataLength() > 0) {
            this.ccCtrl.setSelection(0);
        } else {
            this.fragmentRowFilter.setEnabledIds(new LinkedList<Integer>());
            this.fCtrl.update();
        }
    }
}

