/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.controller;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.ClonePair;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcfviewer.RCFMainWindow;
import de.uni_bremen.st.rcfviewer.controller.RcfRelationCtrl;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFWrapper;
import de.uni_bremen.st.rcfviewer.util.ColumnInfo;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.ColRenderer;
import de.uni_bremen.st.rcfviewer.util.filter.VersionRowFilter;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionEvent;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionListener;
import de.uni_bremen.st.rcfviewer.views.cloneview.CloneView;

public class ClonePairCtrl
extends RcfRelationCtrl {
    private VersionRowFilter cpVersionRowFilter;

    public ClonePairCtrl() {
        super("ClonePair");
        this.addColumn("id");
        this.addColumn("client_id");
        this.setActive(RcfRelationCtrl.getLabelForAttribute("client_id"), false);
        this.addColumn("type");
        ColRenderer fragFileRenderer = new ColRenderer(){

            public String getCompImage(Attribute a, Entry gt) {
                Entry frag;
                if (gt instanceof ClonePair && (frag = ((ClonePair)gt).getEntry(a)) instanceof Fragment) {
                    return ((Fragment)frag).getStart().getFile().getRelativePath();
                }
                return "?no fragment?";
            }

            @Override
            public String getText(Attribute a, Entry gt) {
                return this.getCompImage(a, gt);
            }
        };
        ColumnInfo ciFileLeft = new ColumnInfo("File (Left)", "left", fragFileRenderer);
        this.addColumn(ciFileLeft);
        ColRenderer fragStartRenderer = new ColRenderer(){

            @Override
            public Integer getCompImage(Attribute a, Entry gt) {
                Entry frag;
                if (gt instanceof ClonePair && (frag = ((ClonePair)gt).getEntry(a)) instanceof Fragment) {
                    return ((Fragment)frag).getStart().getLine();
                }
                return -1;
            }

            @Override
            public String getText(Attribute a, Entry gt) {
                return this.getCompImage(a, gt).toString();
            }
        };
        ColumnInfo ciBeginLeft = new ColumnInfo("Start (Left)", "left", fragStartRenderer);
        this.addColumn(ciBeginLeft);
        ColRenderer fragEndRenderer = new ColRenderer(){

            @Override
            public Integer getCompImage(Attribute a, Entry gt) {
                Entry frag;
                if (gt instanceof ClonePair && (frag = ((ClonePair)gt).getEntry(a)) instanceof Fragment) {
                    return ((Fragment)frag).getEnd().getLine();
                }
                return -1;
            }

            @Override
            public String getText(Attribute a, Entry gt) {
                return this.getCompImage(a, gt).toString();
            }
        };
        ColumnInfo ciEndLeft = new ColumnInfo("End (Left)", "left", fragEndRenderer);
        this.addColumn(ciEndLeft);
        ColumnInfo ciFileRight = new ColumnInfo("File (Right)", "right", fragFileRenderer);
        this.addColumn(ciFileRight);
        ColumnInfo ciBeginRight = new ColumnInfo("Start (Right)", "right", fragStartRenderer);
        this.addColumn(ciBeginRight);
        ColumnInfo ciEndRight = new ColumnInfo("End (Right)", "right", fragEndRenderer);
        this.addColumn(ciEndRight);
        ColumnInfo ciNrOfLines = new ColumnInfo("#Lines", new ColRenderer(){

            @Override
            public Comparable getCompImage(Attribute a, Entry gt) {
                if (gt instanceof ClonePair) {
                    ClonePair cp = (ClonePair)gt;
                    Fragment left = cp.getLeft();
                    return Integer.valueOf(left.getEnd().getLine() - left.getStart().getLine() + 1);
                }
                return Integer.valueOf(-1);
            }

            @Override
            public String getText(Attribute a, Entry gt) {
                return this.getCompImage(a, gt).toString();
            }
        });
        this.addColumn(ciNrOfLines);
        ColumnInfo ciNrOfTokens = new ColumnInfo("#Tokens", new ColRenderer(){

            @Override
            public Integer getCompImage(Attribute a, Entry gt) {
                if (gt instanceof ClonePair) {
                    ClonePair cp = (ClonePair)gt;
                    Fragment left = cp.getLeft();
                    Fragment right = cp.getRight();
                    return left.getNumTokens() + right.getNumTokens();
                }
                return -1;
            }

            @Override
            public String getText(Attribute a, Entry gt) {
                return this.getCompImage(a, gt).toString();
            }
        });
        this.addColumn(ciNrOfTokens);
        this.addSelectionListener(new SelectionListener<Entry>(){

            @Override
            public void handleEvent(SelectionEvent e) {
                if (e.getSelection() instanceof ClonePair) {
                    ClonePair selection = (ClonePair)e.getSelection();
                    CloneView cloneView = RCFMainWindow.getInstance().getCloneView();
                    cloneView.set(selection.getLeft(), selection.getRight());
                }
            }
        });
        this.cpVersionRowFilter = new VersionRowFilter(RCFWrapper.getInstance().getVersion());
        this.setRowFilter(this.cpVersionRowFilter);
    }

    @Override
    public void handleVersionChange(Version version) {
        this.cpVersionRowFilter.setVersion(version);
        this.getModel().generateDataList();
        this.update();
    }
}

