/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.controller;

import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcfviewer.controller.Ctrl;
import de.uni_bremen.st.rcfviewer.models.ConsoleModel;
import de.uni_bremen.st.rcfviewer.views.ConsoleView;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public final class ConsoleCtrl
extends Ctrl<ConsoleView> {
    private static ConsoleCtrl instance = null;
    private static TextStyle warningTS;
    private static TextStyle errorTS;
    private static TextStyle debugTS;
    private static TextStyle infoTS;
    private ConsoleView view;
    private ConsoleModel model = new ConsoleModel();

    public static ConsoleCtrl getInstance() {
        return instance;
    }

    private ConsoleCtrl() {
    }

    @Override
    public ConsoleView makeView(Composite parent) {
        if (this.view != null) {
            this.view.dispose();
        }
        this.view = new ConsoleView(parent, this.model);
        return this.view;
    }

    public void setRCF(RCF rcf) {
    }

    public void warning(String s) {
        this.model.append("WARNING: ", warningTS);
        this.message(s);
    }

    public static void printWarning(String s) {
        ConsoleCtrl.getInstance().warning(s);
    }

    public void error(String s) {
        this.model.append("ERROR: ", errorTS);
        this.message(s);
    }

    public static void printError(String s) {
        ConsoleCtrl.getInstance().error(s);
    }

    public void debug(String s) {
        this.model.append("DEBUG: ", debugTS);
        this.message(s);
    }

    public static void printDebug(String s) {
        ConsoleCtrl.getInstance().debug(s);
    }

    public void info(String s) {
        this.model.append("INFO: ", infoTS);
        this.message(s);
    }

    public static void printInfo(String s) {
        ConsoleCtrl.getInstance().info(s);
    }

    public void message(String s) {
        this.model.append(s);
        this.model.append("\n");
        this.view.update();
    }

    public static void printMessage(String s) {
        ConsoleCtrl.getInstance().message(s);
    }

    static {
        instance = new ConsoleCtrl();
        Display display = Display.getCurrent();
        Font font = new Font((Device)Display.getCurrent(), "Bitstream Vera Sans Mono", 11, 0);
        warningTS = new TextStyle(font, display.getSystemColor(12), display.getSystemColor(1));
        errorTS = new TextStyle(font, display.getSystemColor(3), display.getSystemColor(1));
        debugTS = new TextStyle(font, display.getSystemColor(14), display.getSystemColor(1));
        infoTS = new TextStyle(font, display.getSystemColor(9), display.getSystemColor(1));
    }
}

