/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.controller;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.schema.AttributeType;
import de.uni_bremen.st.rcfviewer.controller.Ctrl;
import de.uni_bremen.st.rcfviewer.controller.RcfRelationCtrl;
import de.uni_bremen.st.rcfviewer.models.EntryInspectorModel;
import de.uni_bremen.st.rcfviewer.util.filter.IdRowFilter;
import de.uni_bremen.st.rcfviewer.views.EntryInspectorView;
import de.uni_bremen.st.rcfviewer.views.RcfRelationView;
import de.uni_bremen.st.rcfviewer.views.WindowViewDisposeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class EntryInspectorCtrl
extends Ctrl<EntryInspectorView> {
    private static EntryInspectorCtrl instance = new EntryInspectorCtrl();
    private EntryInspectorView view = null;
    private EntryInspectorModel model = new EntryInspectorModel();

    public static EntryInspectorCtrl getInstance() {
        return instance;
    }

    private EntryInspectorCtrl() {
    }

    @Override
    public EntryInspectorView makeView(Composite parent) {
        if (this.view != null) {
            this.view.dispose();
        }
        this.view = new EntryInspectorView(parent, this, this.model);
        return this.view;
    }

    public void showEntry(Entry e) {
        this.model.addEntry(e);
        if (this.view == null || this.view.getControl().isDisposed()) {
            this.view = EntryInspectorView.create(this);
        }
        this.view.update();
    }

    public void next() {
        if (this.model.hasNext()) {
            this.model.next();
            this.view.update();
        }
    }

    public void previous() {
        if (this.model.hasPrevious()) {
            this.model.previous();
            this.view.update();
        }
    }

    public void showRelation() {
        String relationName = this.model.getRelationName();
        Shell win = new Shell(1264);
        win.setText(String.format("Relation: %s", relationName));
        win.setLayout((Layout)new FillLayout());
        RcfRelationCtrl rcfRCtrl = new RcfRelationCtrl(relationName);
        rcfRCtrl.addAllColumns();
        RcfRelationView view = rcfRCtrl.makeView((Composite)win);
        view.addDisposeListener(new WindowViewDisposeListener(win));
        rcfRCtrl.update();
        win.pack();
        win.open();
    }

    public void showReference(Attribute a, Entry entry) {
        assert (a != null);
        assert (entry != null);
        if (a.getType() != AttributeType.REFERENCE || !entry.isSet(a)) {
            return;
        }
        if (a.isList()) {
            Relation<? extends Entry> refRelation = a.getReferencedRelation();
            List<Entry> refs = entry.getEntryList(a);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (Entry r : refs) {
                ids.add(r.getId());
            }
            IdRowFilter idFilter = new IdRowFilter(ids);
            RcfRelationCtrl rcfCtrl = new RcfRelationCtrl(refRelation.getName());
            rcfCtrl.addAllColumns();
            rcfCtrl.setRowFilter(idFilter);
            Shell win = new Shell(1264);
            win.setText(String.format("%s %d: %s", entry.getRelation().getName(), entry.getId(), a.getName()));
            win.setLayout((Layout)new FillLayout());
            RcfRelationView view = rcfCtrl.makeView((Composite)win);
            view.addDisposeListener(new WindowViewDisposeListener(win));
            rcfCtrl.update();
            win.pack();
            win.open();
        } else {
            Entry ref = entry.getEntry(a);
            this.showEntry(ref);
        }
    }
}

