/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.controller;

import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcfviewer.RCFMainWindow;
import de.uni_bremen.st.rcfviewer.controller.RcfRelationCtrl;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.CalculatingProgressDialog;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker.FileRatioCalculator;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFWrapper;
import de.uni_bremen.st.rcfviewer.util.ColumnInfo;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.RefRenderer;
import de.uni_bremen.st.rcfviewer.util.filter.VersionRowFilter;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionEvent;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionListener;
import de.uni_bremen.st.rcfviewer.views.cloneview.CloneView;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class FileRatiosCtrl
extends RcfRelationCtrl {
    private VersionRowFilter rowFilter = new VersionRowFilter(RCFWrapper.getInstance().getVersion());

    public FileRatiosCtrl() {
        super("FileRatios");
        this.addColumns();
        this.setRowFilter(this.rowFilter);
        this.addSelectionListener(new FileRatioSelectionListener());
    }

    private void addColumns() {
        RefRenderer refRenderer = new RefRenderer();
        ColumnInfo ciVersion = new ColumnInfo("Version", "version", refRenderer);
        ciVersion.setActive(false);
        this.addColumn(ciVersion);
        this.addColumn("id", false);
        ColumnInfo ciFile1 = new ColumnInfo("File 1", "file1", refRenderer);
        this.addColumn(ciFile1);
        this.addColumn(new ColumnInfo("Cloned Lines 1", "clonedLines1"));
        this.addColumn(new ColumnInfo("Cloned Tokens 1", "clonedTokens1"));
        this.addColumn(new ColumnInfo("Percent of cloned Lines 1", "percentOfClonedLines1"));
        this.addColumn(new ColumnInfo("Percent of cloned Tokens 1", "percentOfClonedTokens1"));
        ColumnInfo ciFile2 = new ColumnInfo("File 2", "file2", refRenderer);
        this.addColumn(ciFile2);
        this.addColumn(new ColumnInfo("Cloned Lines 2", "clonedLines2"));
        this.addColumn(new ColumnInfo("Cloned Tokens 2", "clonedTokens2"));
        this.addColumn(new ColumnInfo("Percent of cloned Lines 2", "percentOfClonedLines2"));
        this.addColumn(new ColumnInfo("Percent of cloned Tokens 2", "percentOfClonedTokens2"));
        this.addColumn(new ColumnInfo("Total Relations", "totalRelations"));
        this.addColumn(new ColumnInfo("Type1-Relations", "type1Relations"));
        this.addColumn(new ColumnInfo("Type2-Relations", "type2Relations"));
        ColumnInfo ciPairs = new ColumnInfo("Pairs", "pairs");
        ciPairs.setActive(false);
        this.addColumn(ciPairs);
    }

    public static FileRatiosCtrl create() {
        RCF rcf = RCFWrapper.getInstance().getRCF();
        if (!rcf.hasRelation("FileRatios") || rcf.getRelation("FileRatios").size() <= 0) {
            FileRatioCalculator frc = new FileRatioCalculator(rcf);
            RCFWrapper.getInstance().markChanged();
            CalculatingProgressDialog pd = new CalculatingProgressDialog(Display.getCurrent().getActiveShell(), "Calculate File Ratios", frc, true);
            pd.open();
        }
        return new FileRatiosCtrl();
    }

    @Override
    public void handleVersionChange(Version version) {
        this.rowFilter.setVersion(version);
        this.setRowFilter(this.rowFilter);
        this.update();
    }

    public void setSelection(File f1, File f2) {
        int index = 0;
        String file1 = f1.getRelativePath();
        String file2 = f2.getRelativePath();
        List<String[]> data = this.getModel().getData(this.getModel().getColumns(), 0, Integer.MAX_VALUE);
        int i = 0;
        for (String[] row : data) {
            if (file1.equals(row[1]) && file2.equals(row[4])) {
                index = i;
                break;
            }
            ++i;
        }
        this.setSelection(index);
    }

    private class FileRatioSelectionListener
    implements SelectionListener<Entry> {
        private FileRatioSelectionListener() {
        }

        @Override
        public void handleEvent(SelectionEvent<Entry> e) {
            Entry selectedRatio = FileRatiosCtrl.this.getModel().getSelection();
            Relation<Entry> relPairs = selectedRatio.getRelation().getRCF().getRelation("FileRatioPairs");
            List<Entry> pairs = selectedRatio.getEntryList("pairs");
            CloneView cv = RCFMainWindow.getInstance().getCloneView();
            cv.set(pairs, relPairs);
        }
    }
}

