/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.controller;

import de.uni_bremen.st.rcf.exceptions.NoSuchAttributeException;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcfviewer.controller.Ctrl;
import de.uni_bremen.st.rcfviewer.controller.EntryInspectorCtrl;
import de.uni_bremen.st.rcfviewer.models.RcfRelationModel;
import de.uni_bremen.st.rcfviewer.util.ColumnInfo;
import de.uni_bremen.st.rcfviewer.util.filter.RowFilter;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionListener;
import de.uni_bremen.st.rcfviewer.views.RcfRelationView;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Composite;

public class RcfRelationCtrl
extends Ctrl<RcfRelationView> {
    private static Map<String, String> rcfAttrib2LabelMap = new TreeMap<String, String>();
    private final RcfRelationModel model;
    private RcfRelationView view;

    public RcfRelationCtrl(String relationName) {
        this.model = new RcfRelationModel(relationName);
    }

    @Override
    public RcfRelationView makeView(Composite parent) {
        if (this.view != null) {
            this.view.dispose();
        }
        this.view = new RcfRelationView(parent, this.model, this);
        this.view.update();
        return this.view;
    }

    public void addSelectionListener(SelectionListener<Entry> listener) {
        this.model.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener<Entry> listener) {
        this.model.removeSelectionListener(listener);
    }

    public void setSelection(int index) {
        this.model.setSelection(index);
    }

    public void addColumn(ColumnInfo column) {
        this.model.addColumn(column);
        this.update();
    }

    public void addColumn(String attributeName) {
        this.addColumn(attributeName, true);
    }

    public void addColumn(String attributeName, boolean active) {
        this.model.getRelation();
        ColumnInfo columnInfo = new ColumnInfo(RcfRelationCtrl.getLabelForAttribute(attributeName), attributeName);
        columnInfo.setActive(active);
        this.addColumn(columnInfo);
    }

    public void removeColumn(String label) {
        this.model.removeColumn(label);
    }

    public void addAllColumns() {
        Relation<Entry> relation = this.model.getRelation();
        for (Attribute a : relation.getAttributes()) {
            ColumnInfo ci = new ColumnInfo(RcfRelationCtrl.getLabelForAttribute(a.getName()), a.getName());
            this.model.addColumn(ci);
        }
    }

    public static String getLabelForAttribute(String attribute) {
        String s = rcfAttrib2LabelMap.get(attribute);
        if (s == null) {
            return attribute;
        }
        return s;
    }

    public void update() {
        this.model.generateDataList();
        if (this.view != null) {
            this.view.update();
        }
    }

    public void setActive(String column, boolean active) {
        this.model.setActive(column, active);
    }

    public void setRowFilter(RowFilter rowFilter) {
        this.model.setRowFilter(rowFilter);
    }

    public RcfRelationModel getModel() {
        return this.model;
    }

    public RcfRelationView getView() {
        return this.view;
    }

    public void showReference(int row, int column) {
        ColumnInfo ci = this.model.getActiveColumns().get(column);
        Entry entry = this.model.getEntry(row);
        String attributeName = ci.getAttributeName();
        Relation<Entry> relation = this.model.getRelation();
        try {
            Attribute attribute = relation.getAttribute(attributeName);
            EntryInspectorCtrl.getInstance().showReference(attribute, entry);
        }
        catch (NoSuchAttributeException e) {
            // empty catch block
        }
    }

    @Override
    public void handleRCFLoad(RCF rcf) {
        if (this.canBeDisplayed(rcf)) {
            this.update();
        } else {
            this.dispose();
        }
    }

    @Override
    public void handleRCFChange() {
    }

    @Override
    public void handleRCFSave() {
    }

    @Override
    public void handleVersionChange(Version version) {
    }

    public boolean canBeDisplayed(RCF rcf) {
        return rcf.hasRelation(this.getModel().getRelationName());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.view != null) {
            this.view.dispose();
        }
    }

    static {
        rcfAttrib2LabelMap.put("id", "ID");
        rcfAttrib2LabelMap.put("type", "Type");
        rcfAttrib2LabelMap.put("file", "File");
        rcfAttrib2LabelMap.put("begin_line", "Start Line");
        rcfAttrib2LabelMap.put("end_line", "End Line");
        rcfAttrib2LabelMap.put("begin_column", "Start Col");
        rcfAttrib2LabelMap.put("end_column", "End Col");
        rcfAttrib2LabelMap.put("loc", "LOC");
        rcfAttrib2LabelMap.put("num_tokens", "#Tokens");
        rcfAttrib2LabelMap.put("name", "Name");
        rcfAttrib2LabelMap.put("client_id", "Client ID");
        rcfAttrib2LabelMap.put("directory", "Directory");
        rcfAttrib2LabelMap.put("path", "Path");
        rcfAttrib2LabelMap.put("basepath", "Basepath");
        rcfAttrib2LabelMap.put("version", "Version");
        rcfAttrib2LabelMap.put("fragments", "Fragments");
        rcfAttrib2LabelMap.put("CloneClass", "Clone Class");
        rcfAttrib2LabelMap.put("ConePair", "Cone Pair");
    }
}

