/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.dialogs;

import de.uni_bremen.st.rcfviewer.RCFMainWindow;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFWrapper;
import java.io.File;
import java.util.concurrent.CancellationException;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;

public final class MainDialogs {
    private static final RCFWrapper rcf = RCFWrapper.getInstance();
    private static final FileDialog rcfFileDialog = new FileDialog(RCFMainWindow.getInstance().getShell(), 4096);
    private static final FileDialog commonFileDialog;
    private static final DirectoryDialog commonDirectoryDialog;

    private MainDialogs() {
    }

    public static String showOpenRCFDialog() {
        String filename = rcfFileDialog.open();
        while (null != filename && !new File(filename).exists()) {
            MainDialogs.showErrorMessage("File: " + filename + " not found");
            filename = rcfFileDialog.open();
        }
        return filename;
    }

    public static String showChooseFileDialog() {
        String filename = commonFileDialog.open();
        while (null != filename && !new File(filename).exists()) {
            MainDialogs.showErrorMessage("File: " + filename + " not found");
            filename = commonFileDialog.open();
        }
        return filename;
    }

    public static String showChooseDirectoryDialog() {
        String dirName = commonDirectoryDialog.open();
        while (null != dirName && !new File(dirName).exists()) {
            MainDialogs.showErrorMessage("Directory:" + dirName + " not found");
            dirName = commonDirectoryDialog.open();
        }
        return dirName;
    }

    public static void showSaveAsDialog() {
        FileDialog fdSave = new FileDialog(RCFMainWindow.getInstance().getShell(), 8192);
        fdSave.setText("Save RCF file");
        fdSave.setFilterExtensions(new String[]{"*.rcf", "*.*"});
        fdSave.setFilterNames(new String[]{"RCF(*.rcf)", "All Files"});
        String filename = fdSave.open();
        if (filename != null) {
            File file = new File(filename);
            try {
                if (!file.exists()) {
                    RCFWrapper.getInstance().saveAs(file);
                } else {
                    MessageBox msgBox = new MessageBox(RCFMainWindow.getInstance().getShell(), 192);
                    msgBox.setMessage("Overwrite existing file?");
                    switch (msgBox.open()) {
                        case 64: {
                            RCFWrapper.getInstance().saveAs(file);
                            break;
                        }
                    }
                }
            }
            catch (RuntimeException re) {
                MainDialogs.showErrorMessage("Cannot write file.");
            }
        }
    }

    public static void showErrorMessage(String msg) {
        MessageBox msgBox = new MessageBox(RCFMainWindow.getInstance().getShell(), 1);
        msgBox.setMessage(msg);
        msgBox.open();
    }

    public static boolean showSaveDialog() throws CancellationException {
        if (rcf.hasChangedRCF()) {
            MessageBox msgBox = new MessageBox(RCFMainWindow.getInstance().getShell(), 452);
            msgBox.setText("Save RCF");
            msgBox.setMessage("Do you want to save the RCF-file?");
            int result = msgBox.open();
            if (result == 64) {
                if (rcf.isRcfImported()) {
                    MainDialogs.showSaveAsDialog();
                } else {
                    rcf.save();
                }
                return true;
            }
            if (result == 128) {
                return false;
            }
            throw new CancellationException();
        }
        return false;
    }

    static {
        rcfFileDialog.setText("Load RCF file");
        rcfFileDialog.setFilterExtensions(new String[]{"*.rcf", "*.*"});
        rcfFileDialog.setFilterNames(new String[]{"RCF(*.rcf)", "All Files"});
        commonFileDialog = new FileDialog(RCFMainWindow.getInstance().getShell(), 4096);
        commonFileDialog.setText("Choose file");
        commonDirectoryDialog = new DirectoryDialog(RCFMainWindow.getInstance().getShell());
        commonDirectoryDialog.setText("Choose directory");
    }
}

