/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.dialogs;

import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcfviewer.RCFMainWindow;
import de.uni_bremen.st.rcfviewer.controller.RcfRelationCtrl;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFWrapper;
import de.uni_bremen.st.rcfviewer.views.RcfRelationView;
import de.uni_bremen.st.rcfviewer.views.WindowViewDisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ViewRelationSelectDialog {
    private final RCFMainWindow mainWindow;
    private final Shell shell;
    private final Combo combo;

    public ViewRelationSelectDialog(RCFMainWindow rcfMainWindow) {
        this.mainWindow = rcfMainWindow;
        this.shell = new Shell(rcfMainWindow.getShell());
        this.shell.setText("Choose Relation to show");
        this.shell.setLayout((Layout)new FormLayout());
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Relation:");
        this.combo = new Combo((Composite)this.shell, 8);
        FormData lD = new FormData();
        lD.left = new FormAttachment(0, 0);
        lD.bottom = new FormAttachment((Control)this.combo, 0, 0x1000000);
        label.setLayoutData((Object)lD);
        FormData cD = new FormData();
        cD.top = new FormAttachment(0, 0);
        cD.left = new FormAttachment((Control)label, 0);
        cD.right = new FormAttachment(100, 0);
        this.combo.setLayoutData((Object)cD);
        RCF rcf = RCFWrapper.getInstance().getRCF();
        if (null == rcf) {
            this.combo.add("Metadata");
            this.combo.add("Version");
            this.combo.add("ClonePair");
            this.combo.add("CloneClass");
            this.combo.add("File");
            this.combo.add("Fragment");
        } else {
            for (Relation<Entry> r : rcf.getRelations()) {
                this.combo.add(r.getName());
            }
        }
        Button btnTab = new Button((Composite)this.shell, 8);
        btnTab.setText("Show as &Tab");
        FormData btD = new FormData();
        btD.left = new FormAttachment(0, 0);
        btD.top = new FormAttachment((Control)this.combo, 0);
        btnTab.setLayoutData((Object)btD);
        btnTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int idx = ViewRelationSelectDialog.this.combo.getSelectionIndex();
                if (idx < 0 || idx >= ViewRelationSelectDialog.this.combo.getItemCount()) {
                    return;
                }
                String s = ViewRelationSelectDialog.this.combo.getItem(ViewRelationSelectDialog.this.combo.getSelectionIndex());
                ViewRelationSelectDialog.this.mainWindow.setBottomSelection(ViewRelationSelectDialog.this.mainWindow.addBottomItem("Show:" + s, ViewRelationSelectDialog.this.createRcfRelationCtrl(s)));
                ViewRelationSelectDialog.this.dispose();
            }
        });
        Button btnWindow = new Button((Composite)this.shell, 8);
        btnWindow.setText("Show as &Window");
        FormData bwD = new FormData();
        bwD.left = new FormAttachment((Control)btnTab, 0);
        bwD.top = new FormAttachment((Control)this.combo, 0);
        btnWindow.setLayoutData((Object)bwD);
        btnWindow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int idx = ViewRelationSelectDialog.this.combo.getSelectionIndex();
                if (idx < 0 || idx >= ViewRelationSelectDialog.this.combo.getItemCount()) {
                    return;
                }
                String s = ViewRelationSelectDialog.this.combo.getItem(idx);
                Shell win = new Shell(1264);
                win.setText(s);
                win.setLayout((Layout)new FillLayout());
                RcfRelationView view = ViewRelationSelectDialog.this.createRcfRelationCtrl(s).makeView((Composite)win);
                view.addDisposeListener(new WindowViewDisposeListener(win));
                win.pack();
                win.open();
                ViewRelationSelectDialog.this.dispose();
            }
        });
        Button btnCancel = new Button((Composite)this.shell, 8);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ViewRelationSelectDialog.this.dispose();
            }
        });
        btnCancel.setText("&Cancel");
        FormData bcD = new FormData();
        bcD.right = new FormAttachment(100, 0);
        bcD.top = new FormAttachment((Control)this.combo, 0);
        bcD.left = new FormAttachment((Control)btnWindow, 0);
        btnCancel.setLayoutData((Object)bcD);
    }

    public void open() {
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void dispose() {
        this.shell.dispose();
    }

    private RcfRelationCtrl createRcfRelationCtrl(String name) {
        RcfRelationCtrl rc = new RcfRelationCtrl(name);
        rc.addAllColumns();
        rc.update();
        return rc;
    }
}

