/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.dialogs.imports;

import de.uni_bremen.st.rcfviewer.dialogs.MainDialogs;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker.imports.AbstractImportWorker;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFWrapper;
import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractImportDialog {
    private final Shell shell;

    public abstract AbstractImportWorker getImportWorker(File var1, String var2);

    protected boolean isValid(File file, String baseDir) {
        if (!(file.isFile() && file.exists() && file.canRead())) {
            MainDialogs.showErrorMessage("The path to the import file is not valid.");
            return false;
        }
        return true;
    }

    public AbstractImportDialog(Shell parent) {
        this.shell = new Shell(parent, 67616);
        this.shell.setText("Import from file");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout((Layout)gridLayout);
        Label importFileLabel = new Label((Composite)this.shell, 0);
        importFileLabel.setText("import file:");
        GridData gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 2;
        importFileLabel.setLayoutData((Object)gridData);
        final Text importFileText = new Text((Composite)this.shell, 2052);
        gridData = new GridData(400, -1);
        importFileText.setLayoutData((Object)gridData);
        Button importFileButton = new Button((Composite)this.shell, 8);
        importFileButton.setText("...");
        importFileButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String file = MainDialogs.showChooseFileDialog();
                if (null != file) {
                    importFileText.setText(file);
                }
            }
        });
        Label baseDirLabel = new Label((Composite)this.shell, 0);
        baseDirLabel.setText("base directory:");
        gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 2;
        baseDirLabel.setLayoutData((Object)gridData);
        final Text baseDirText = new Text((Composite)this.shell, 2052);
        gridData = new GridData(400, -1);
        baseDirText.setLayoutData((Object)gridData);
        Button baseDirButton = new Button((Composite)this.shell, 8);
        baseDirButton.setText("...");
        baseDirButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String file = MainDialogs.showChooseDirectoryDialog();
                if (null != file) {
                    baseDirText.setText(file);
                }
            }
        });
        Button importButton = new Button((Composite)this.shell, 8);
        importButton.setText("import");
        importButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (importFileText.getText().length() == 0) {
                    MainDialogs.showErrorMessage("Please specify a valid path for the import file.");
                } else if (baseDirText.getText().length() == 0) {
                    MainDialogs.showErrorMessage("Please specify a valid path for the base directory.");
                } else {
                    File file = new File(importFileText.getText());
                    if (AbstractImportDialog.this.isValid(file, baseDirText.getText())) {
                        AbstractImportWorker worker = AbstractImportDialog.this.getImportWorker(file, baseDirText.getText());
                        if (RCFWrapper.getInstance().importRCF(worker)) {
                            AbstractImportDialog.this.shell.dispose();
                        } else {
                            MainDialogs.showErrorMessage("An error occurred while importing the file.");
                        }
                    }
                }
            }
        });
    }

    public void open() {
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }
}

