/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.dialogs.progressbars;

import de.uni_bremen.st.rcfviewer.dialogs.progressbars.ProgressListener;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker.Worker;
import de.uni_bremen.st.rcfviewer.util.SWTHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public abstract class ProgressDialog
implements ProgressListener {
    private Shell shell;
    private ProgressBar progressBar;
    private Worker worker;

    public ProgressDialog(Shell owner, String title, final Worker worker, boolean cancelable) {
        this.worker = worker;
        this.shell = this.setupShell(owner, title);
        this.progressBar = this.getProgressBar();
        if (cancelable) {
            Button cancel = new Button((Composite)this.shell, 8);
            cancel.setText("&Cancel");
            cancel.setLayoutData((Object)new GridData(4, 4, true, true));
            cancel.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    worker.cancel();
                }
            });
        }
        worker.addProgressListener(this);
        this.shell.pack();
        this.shell.setLocation(SWTHelper.calculateCenterPosition(this.shell));
    }

    public ProgressDialog(String title, Worker worker, boolean cancelable) {
        this(Display.getCurrent().getActiveShell(), title, worker, cancelable);
    }

    public void open() {
        this.shell.open();
        new Thread(this.worker).start();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void dispose() {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.shell.dispose();
            }
        });
    }

    protected final Shell getShell() {
        return this.shell;
    }

    protected abstract ProgressBar getProgressBar();

    private Shell setupShell(Shell owner, String title) {
        Shell shell = new Shell(owner, 67616);
        shell.setText(title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        shell.setLayout((Layout)gl);
        return shell;
    }

    @Override
    public void progressMade(final double percent) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setSelection((int)(percent * 100.0));
                ProgressDialog.this.shell.getDisplay().wake();
            }
        });
    }

    @Override
    public void finished() {
        this.dispose();
    }

    @Override
    public void cancelled() {
        this.dispose();
    }
}

