/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker;

import de.uni_bremen.st.rcfviewer.dialogs.progressbars.ProgressListener;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker.Worker;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractWorker
implements Worker {
    protected List<ProgressListener> pListeners = new LinkedList<ProgressListener>();
    protected final AtomicBoolean cancelled = new AtomicBoolean(false);

    protected void fireProgressMade(double percent) {
        for (ProgressListener pl : this.pListeners) {
            pl.progressMade(percent);
        }
    }

    protected void fireCancelled() {
        for (ProgressListener pl : this.pListeners) {
            pl.cancelled();
        }
    }

    protected void fireFinished() {
        for (ProgressListener pl : this.pListeners) {
            pl.finished();
        }
    }

    @Override
    public void addProgressListener(ProgressListener pListener) {
        this.pListeners.add(pListener);
    }

    @Override
    public void cancel() {
        this.cancelled.set(true);
    }

    protected boolean isCancelled() {
        return this.cancelled.get();
    }
}

