/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker;

import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker.AbstractWorker;
import de.uni_bremen.st.rcfviewer.util.FragmentContext;
import de.uni_bremen.st.rcfviewer.util.languages.AbstractLanguage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerException;
import org.conqat.lib.scanner.ScannerFactory;

public class ContextGenerator
extends AbstractWorker {
    private long max = 0L;
    private long current = 0L;
    private final List<Fragment> fragments;
    private final Map<Integer, FragmentContext> fragmentContexts;

    public ContextGenerator(List<Fragment> fragments, Map<Integer, FragmentContext> fragmentContexts) {
        this.fragments = fragments;
        this.fragmentContexts = fragmentContexts;
        assert (fragments != null) : "cannot get fragments from null clone class";
    }

    @Override
    public void run() {
        de.uni_bremen.st.rcf.model.File fragFile;
        for (Fragment frag : this.fragments) {
            if (this.isCancelled()) {
                this.fireCancelled();
                break;
            }
            fragFile = frag.getStart().getFile();
            File f = new File(fragFile.getAbsolutePath());
            this.max += f.length();
        }
        for (Fragment frag : this.fragments) {
            if (this.isCancelled()) {
                this.fireCancelled();
                break;
            }
            fragFile = frag.getStart().getFile();
            String absoluteFilename = fragFile.getAbsolutePath();
            File file = new File(absoluteFilename);
            FragmentContext context = new FragmentContext(frag);
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                StringBuilder tokenInput = new StringBuilder();
                for (int i = 1; i < frag.getEnd().getLine() + context.getContextMargin() && (line = br.readLine()) != null && i <= frag.getEnd().getLine() + context.getContextMargin(); ++i) {
                    if (i > frag.getStart().getLine() - context.getContextMargin() && i < frag.getStart().getLine()) {
                        context.appendPreText(line);
                    } else if (i >= frag.getStart().getLine() && i <= frag.getEnd().getLine()) {
                        context.appendText(line);
                    } else if (i > frag.getEnd().getLine() && i < frag.getEnd().getLine() + context.getContextMargin()) {
                        context.appendPostText(line);
                    }
                    if (i <= frag.getStart().getLine() - context.getContextMargin()) continue;
                    tokenInput.append(line);
                    tokenInput.append("\n");
                }
                br.close();
                context.setLanguage(AbstractLanguage.languageFromFileName(absoluteFilename));
                ILenientScanner scanner = ScannerFactory.newLenientScanner(context.getLanguage().getScannerLanguage(), tokenInput.toString(), file.getAbsolutePath());
                IToken token = null;
                try {
                    token = scanner.getNextToken();
                }
                catch (ScannerException se) {
                    se.printStackTrace();
                }
                while (token != null && token.getType() != ETokenType.EOF) {
                    context.addToken(token);
                    try {
                        token = scanner.getNextToken();
                    }
                    catch (ScannerException se) {
                        se.printStackTrace();
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.fragmentContexts.put(frag.getId(), context);
            this.current += file.length();
            this.fireProgressMade((double)this.current / (double)this.max);
        }
        this.fireFinished();
    }
}

