/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker;

import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.model.Versions;
import de.uni_bremen.st.rcf.util.FileRatios;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker.AbstractWorker;

public class FileRatioCalculator
extends AbstractWorker {
    private RCF rcf;

    public FileRatioCalculator(RCF rcf) {
        this.rcf = rcf;
    }

    @Override
    public void run() {
        this.fireProgressMade(0.0);
        FileRatios.createSchema(this.rcf);
        Versions versions = this.rcf.getVersions();
        int numOfVersions = versions.size() + 1;
        this.fireProgressMade(1.0 / (double)numOfVersions);
        if (this.isCancelled()) {
            this.fireCancelled();
            return;
        }
        int currVersion = 2;
        for (Version v : versions) {
            if (this.isCancelled()) {
                this.fireCancelled();
                return;
            }
            FileRatios.calculateFileRations(v);
            this.fireProgressMade((double)currVersion / (double)numOfVersions);
            ++currVersion;
        }
        this.fireFinished();
    }
}

