/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.models;

import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionEvent;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionListener;
import java.util.LinkedList;
import java.util.List;

public class CloneClassModel {
    private Version version;
    private List<SelectionListener<CloneClass>> cloneClassSelectionListeners = new LinkedList<SelectionListener<CloneClass>>();
    private List<SelectionListener<Fragment>> fragmentSelectionListeners = new LinkedList<SelectionListener<Fragment>>();
    private CloneClass cloneClassSelection = null;
    private Fragment fragmentSelection = null;

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public void addCloneClassSelectionListener(SelectionListener<CloneClass> listener) {
        this.cloneClassSelectionListeners.add(listener);
    }

    public void removeCloneClassSelectionListener(SelectionListener<CloneClass> listener) {
        this.cloneClassSelectionListeners.remove(listener);
    }

    public void setSelectedCloneClass(CloneClass cc) {
        this.cloneClassSelection = cc;
        this.notifyCloneClassListeners();
    }

    public CloneClass getSelectedCloneClass() {
        return this.cloneClassSelection;
    }

    public void notifyCloneClassListeners() {
        SelectionEvent<CloneClass> event = new SelectionEvent<CloneClass>(this, this.cloneClassSelection);
        for (SelectionListener<CloneClass> l : this.cloneClassSelectionListeners) {
            l.handleEvent(event);
        }
    }

    public void addFragmentSelectionListener(SelectionListener<Fragment> listener) {
        this.fragmentSelectionListeners.add(listener);
    }

    public void removeFragmentSelectionListener(SelectionListener<Fragment> listener) {
        this.fragmentSelectionListeners.remove(listener);
    }

    public void setSelectedFragment(Fragment f) {
        this.fragmentSelection = f;
        this.notifyFragmentListeners();
    }

    public Fragment getSelectedFragment() {
        return this.fragmentSelection;
    }

    public void notifyFragmentListeners() {
        SelectionEvent<Fragment> event = new SelectionEvent<Fragment>(this, this.fragmentSelection);
        for (SelectionListener<Fragment> l : this.fragmentSelectionListeners) {
            l.handleEvent(event);
        }
    }
}

