/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.models;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class ConsoleModel {
    private StringBuffer text = new StringBuffer();
    private List<StyleRange> styles = new LinkedList<StyleRange>();
    private static final Color DEFAULT_FGC = Display.getCurrent().getSystemColor(2);
    private static final Color DEFAULT_BGC = Display.getCurrent().getSystemColor(1);

    public ConsoleModel() {
    }

    public ConsoleModel(StringBuffer sb) {
        this.text.append(sb);
    }

    public ConsoleModel(String s) {
        this.text.append(s);
    }

    public void setText(String s) {
        this.setText(new StringBuffer(s));
    }

    public void setText(StringBuffer sb) {
        this.text = new StringBuffer();
        this.styles.clear();
        this.append(sb);
    }

    public void setText(String s, TextStyle style) {
        this.text = new StringBuffer(s);
        this.styles.clear();
        StyleRange sr = new StyleRange(style);
        sr.start = 0;
        sr.length = this.text.length();
        this.styles.add(sr);
    }

    public void append(StringBuffer sb) {
        this.styles.add(new StyleRange(this.text.length(), sb.length(), DEFAULT_FGC, DEFAULT_BGC));
        this.text.append(sb);
    }

    public void append(String s) {
        this.text.append(new StringBuffer(s));
    }

    public void append(String s, TextStyle style) {
        StyleRange sr = new StyleRange(style);
        sr.start = this.text.length();
        sr.length = s.length();
        this.text.append(s);
        this.styles.add(sr);
    }

    public String getText() {
        return this.text.toString();
    }

    public StyleRange[] getStyleRanges() {
        return this.styles.toArray(new StyleRange[this.styles.size()]);
    }
}

