/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.models;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.schema.AttributeType;
import de.uni_bremen.st.rcfviewer.models.EntryInspectorAttribute;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.DefaultColRenderer;
import java.util.ArrayList;
import java.util.List;

public class EntryInspectorModel {
    private List<Entry> entries = new ArrayList<Entry>();
    private int currentEntryIndex = 0;

    public void addEntry(Entry e) {
        if (this.currentEntryIndex < this.entries.size()) {
            int begin = this.currentEntryIndex;
            if (!this.entries.get(this.currentEntryIndex).equals(e)) {
                ++begin;
            }
            this.entries.subList(begin, this.entries.size()).clear();
        }
        this.entries.add(e);
        this.currentEntryIndex = this.entries.size() - 1;
    }

    public Entry next() {
        return this.entries.get(++this.currentEntryIndex);
    }

    public Entry previous() {
        return this.entries.get(--this.currentEntryIndex);
    }

    public boolean hasNext() {
        return this.currentEntryIndex < this.entries.size() - 1;
    }

    public boolean hasPrevious() {
        return this.currentEntryIndex > 0;
    }

    public List<EntryInspectorAttribute> getData() {
        Entry currentEntry = this.entries.get(this.currentEntryIndex);
        List<Attribute> attributes = currentEntry.getRelation().getAttributes();
        ArrayList<EntryInspectorAttribute> data = new ArrayList<EntryInspectorAttribute>(attributes.size());
        DefaultColRenderer renderer = new DefaultColRenderer();
        for (Attribute a : attributes) {
            if (a.getType() == AttributeType.REFERENCE) {
                data.add(new EntryInspectorAttribute(a.getName(), renderer.getText(a, currentEntry), currentEntry, a));
                continue;
            }
            data.add(new EntryInspectorAttribute(a.getName(), renderer.getText(a, currentEntry)));
        }
        return data;
    }

    public String getRelationName() {
        return this.entries.get(this.currentEntryIndex).getRelation().getName();
    }

    public int getId() {
        return this.entries.get(this.currentEntryIndex).getId();
    }
}

