/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.models;

import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFWrapper;
import de.uni_bremen.st.rcfviewer.util.ColumnInfo;
import de.uni_bremen.st.rcfviewer.util.filter.RowFilter;
import de.uni_bremen.st.rcfviewer.util.filter.ShowAllRowFilter;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionEvent;
import de.uni_bremen.st.rcfviewer.util.listener.SelectionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public class RcfRelationModel {
    private RCFWrapper rcfWrapper;
    private String relationName;
    private String sortColumn = "";
    private boolean reverseSort = false;
    private Map<String, ColumnInfo> columnInfos;
    private List<ColumnInfo> columnInfosList;
    private List<SelectionListener<Entry>> selectionListeners;
    private List<Entry> dataList;
    private Entry selection = null;
    private RowFilter rowFilter = new ShowAllRowFilter();

    public RcfRelationModel(String relationName) {
        this.rcfWrapper = RCFWrapper.getInstance();
        this.relationName = relationName;
        this.columnInfos = new TreeMap<String, ColumnInfo>();
        this.columnInfosList = new LinkedList<ColumnInfo>();
        this.selectionListeners = new LinkedList<SelectionListener<Entry>>();
        this.dataList = new LinkedList<Entry>();
    }

    public void setActive(String name, boolean active) {
        ColumnInfo ci = this.columnInfos.get(name);
        if (ci != null) {
            ci.setActive(active);
        }
    }

    public void addColumn(ColumnInfo column) {
        if (!this.columnInfos.containsKey(column.getLabel())) {
            this.columnInfos.put(column.getLabel(), column);
            this.columnInfosList.add(column);
            if (this.sortColumn.equals("")) {
                this.setSortColumn(column.getLabel());
            }
        }
    }

    public void removeColumn(String label) {
        if (this.columnInfos.remove(label) != null) {
            ListIterator<ColumnInfo> i = this.columnInfosList.listIterator();
            while (i.hasNext()) {
                if (!i.next().getLabel().equals(label)) continue;
                i.remove();
                break;
            }
            if (this.sortColumn.equals(label)) {
                this.sortColumn = "";
            }
        }
    }

    public void setSortColumn(String column) {
        if (this.columnInfos.containsKey(column)) {
            this.sortColumn = column;
        }
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public Relation<Entry> getRelation() {
        if (this.rcfWrapper == null) {
            return null;
        }
        return this.rcfWrapper.getRCF().getRelation(this.relationName);
    }

    public List<ColumnInfo> getActiveColumns() {
        LinkedList<ColumnInfo> activeColumns = new LinkedList<ColumnInfo>();
        for (ColumnInfo ci : this.columnInfosList) {
            if (!ci.isActive()) continue;
            activeColumns.add(ci);
        }
        return activeColumns;
    }

    public List<ColumnInfo> getColumns() {
        return new LinkedList<ColumnInfo>(this.columnInfosList);
    }

    public ColumnInfo getColumn(String name) {
        return this.columnInfos.get(name);
    }

    public String[] getData(int index) {
        return this.getData(this.getActiveColumns(), index);
    }

    public String[] getData(List<ColumnInfo> columns, int index) {
        Relation<Entry> relation = this.rcfWrapper.getRCF().getRelation(this.relationName);
        Entry e = this.dataList.get(index);
        String[] row = new String[columns.size()];
        int i = 0;
        for (ColumnInfo ci : columns) {
            row[i] = ci.getText(relation, e);
            ++i;
        }
        return row;
    }

    public List<String[]> getData(List<ColumnInfo> columns, int offset, int max) {
        LinkedList<String[]> data = new LinkedList<String[]>();
        Relation<Entry> relation = this.rcfWrapper.getRCF().getRelation(this.relationName);
        if (offset < this.dataList.size()) {
            ListIterator<Entry> iter = this.dataList.listIterator(offset);
            for (int count = 0; iter.hasNext() && count < max; ++count) {
                Entry gt = iter.next();
                String[] row = new String[columns.size()];
                int i = 0;
                for (ColumnInfo ci : columns) {
                    row[i] = ci.getText(relation, gt);
                    ++i;
                }
                data.add(row);
            }
        }
        return data;
    }

    public void generateDataList() {
        this.dataList.clear();
        for (ColumnInfo ci : this.getColumns()) {
            ci.setPreferredWidth(0);
        }
        ColumnInfo sc = this.columnInfos.get(this.sortColumn);
        if (sc == null || this.rcfWrapper == null) {
            return;
        }
        Relation<Entry> relation = this.rcfWrapper.getRCF().getRelation(this.relationName);
        if (relation == null) {
            return;
        }
        for (Entry e : relation) {
            if (!this.rowFilter.filter(e)) continue;
            this.dataList.add(e);
            this.calculatePreferredWidth(e);
        }
        Comparator<Entry> comp = sc.getComparator(relation);
        if (this.reverseSort) {
            comp = Collections.reverseOrder(comp);
        }
        Collections.sort(this.dataList, comp);
    }

    private void calculatePreferredWidth(Entry e) {
        for (ColumnInfo ci : this.getColumns()) {
            ci.setPreferredWidth(Math.max(ci.getPreferredWidth(), ci.getText(this.getRelation(), e).length()));
        }
    }

    public int getDataLength() {
        return this.dataList.size();
    }

    public void addSelectionListener(SelectionListener<Entry> listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener<Entry> listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(int index) {
        try {
            this.selection = this.dataList.get(index);
        }
        catch (IndexOutOfBoundsException iobe) {
            this.selection = null;
        }
        this.notifyListeners();
    }

    public Entry getSelection() {
        return this.selection;
    }

    public int getSelectionIndex() {
        if (this.dataList == null) {
            return -1;
        }
        return this.dataList.indexOf(this.selection);
    }

    public void notifyListeners() {
        SelectionEvent<Entry> event = new SelectionEvent<Entry>(this, this.selection);
        for (SelectionListener<Entry> l : this.selectionListeners) {
            l.handleEvent(event);
        }
    }

    public void setRowFilter(RowFilter rowFilter) {
        this.rowFilter = rowFilter;
    }

    public void setReverseSort(boolean b) {
        this.reverseSort = b;
    }

    public boolean getReverseSort() {
        return this.reverseSort;
    }

    public Entry getEntry(int index) {
        return this.dataList.get(index);
    }
}

