/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.rcfwrapper;

import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.persistence.AbstractPersistenceManager;
import de.uni_bremen.st.rcf.persistence.PersistenceManagerFactory;
import de.uni_bremen.st.rcf.persistence.bauhaus.BauhausPersistenceManager;
import de.uni_bremen.st.rcf.util.FileVersionHandler;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.KnightRiderProgressDialog;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker.SaveWorker;
import de.uni_bremen.st.rcfviewer.dialogs.progressbars.worker.imports.AbstractImportWorker;
import de.uni_bremen.st.rcfviewer.rcfwrapper.RCFEventListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class RCFWrapper {
    private static RCFWrapper instance = null;
    private RCF rcf = null;
    private Version version = null;
    private Set<RCFEventListener> listeners;
    private boolean hasChangedRCF = false;
    private boolean isRcfImported = false;
    private final FileVersionHandler fileVersionHandler = FileVersionHandler.getInstance();

    private RCFWrapper() {
        this.listeners = new CopyOnWriteArraySet<RCFEventListener>();
    }

    public static RCFWrapper getInstance() {
        return instance;
    }

    public RCF getRCF() {
        return this.rcf;
    }

    public boolean hasChangedRCF() {
        return this.hasChangedRCF;
    }

    public boolean isRcfImported() {
        return this.isRcfImported;
    }

    public void loadRCF(String filename) throws FileNotFoundException {
        File f = new File(filename);
        AbstractPersistenceManager pm = PersistenceManagerFactory.getPersistenceManager(f);
        this.rcf = pm.load(f);
        this.version = this.rcf.getVersions().size() > 0 ? (Version)this.rcf.getVersions().getFirstEntry() : null;
        this.fileVersionHandler.setRCF(this.rcf);
        this.hasChangedRCF = false;
        this.isRcfImported = false;
        this.notifyLoaded();
        this.notifyVersionChanged();
    }

    public boolean importRCF(AbstractImportWorker worker) {
        KnightRiderProgressDialog pd = new KnightRiderProgressDialog("Importing file...", worker, false);
        pd.open();
        if (worker.exceptionWasThrown()) {
            return false;
        }
        this.rcf = worker.getRcf();
        this.version = this.rcf.getVersions().size() > 0 ? (Version)this.rcf.getVersions().getFirstEntry() : null;
        this.fileVersionHandler.setRCF(this.rcf);
        this.hasChangedRCF = true;
        this.isRcfImported = true;
        this.notifyImported();
        this.notifyVersionChanged();
        return true;
    }

    public void createTmp(File rcfFile) {
        BauhausPersistenceManager pm = new BauhausPersistenceManager();
        this.rcf = pm.create(rcfFile);
        this.notifyLoadedTmp();
    }

    public void markChanged() {
        this.hasChangedRCF = true;
        this.notifyChanged();
    }

    public void save() {
        new KnightRiderProgressDialog("saving RCF-file", new SaveWorker(this.rcf), false).open();
        this.hasChangedRCF = false;
        this.notifySaved();
    }

    public void saveAs(File f) {
        this.rcf.saveAs(f);
        this.hasChangedRCF = false;
        this.notifySaved();
    }

    public void setVersion(Version version) {
        this.version = version;
        this.notifyVersionChanged();
    }

    public Version getVersion() {
        return this.version;
    }

    public void addRCFListener(RCFEventListener l) {
        this.listeners.add(l);
    }

    public void removeRCFListener(RCFEventListener l) {
        this.listeners.remove(l);
    }

    private void notifyLoaded() {
        for (RCFEventListener l : this.listeners) {
            l.handleRCFLoad(this.rcf);
        }
    }

    private void notifyLoadedTmp() {
        for (RCFEventListener l : this.listeners) {
            l.handleRCFLoadTmp(this.rcf);
        }
    }

    private void notifyImported() {
        for (RCFEventListener l : this.listeners) {
            l.handleRCFImported(this.rcf);
        }
    }

    private void notifyChanged() {
        for (RCFEventListener l : this.listeners) {
            l.handleRCFChange();
        }
    }

    private void notifySaved() {
        for (RCFEventListener l : this.listeners) {
            l.handleRCFSave();
        }
    }

    private void notifyVersionChanged() {
        for (RCFEventListener l : this.listeners) {
            l.handleVersionChange(this.version);
        }
    }

    static {
        instance = new RCFWrapper();
    }
}

