/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.util;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.ColRenderer;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.DefaultColRenderer;
import de.uni_bremen.st.rcfviewer.util.comparatorfactories.ComparatorFactory;
import de.uni_bremen.st.rcfviewer.util.comparatorfactories.DefaultComparatorFactory;
import java.util.Comparator;

public class ColumnInfo {
    static final int MAX_WIDTH = 45;
    private boolean active;
    private String label;
    private String attribute;
    private ColRenderer renderer;
    private ComparatorFactory compFactory;
    private int minWidth = 3;
    private int preferredWidth = 0;
    private int maxWidth = 45;

    public ColumnInfo(String label, ColRenderer renderer) {
        this(label, null, renderer, null, true);
    }

    public ColumnInfo(String label, String attribute) {
        this(label, attribute, new DefaultColRenderer(), null, true);
    }

    public ColumnInfo(String label, String attribute, ColRenderer renderer) {
        this(label, attribute, renderer, null, true);
    }

    public ColumnInfo(String label, String attribute, ColRenderer renderer, ComparatorFactory compFactory, boolean active) {
        this.label = label;
        this.attribute = attribute;
        this.renderer = renderer;
        this.active = active;
        assert (label != null);
        assert (renderer != null);
        if (compFactory == null) {
            compFactory = new DefaultComparatorFactory(attribute, renderer);
        }
        this.compFactory = compFactory;
    }

    public String getLabel() {
        return this.label;
    }

    public String getAttributeName() {
        return this.attribute;
    }

    public ColRenderer getRenderer() {
        return this.renderer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public String getText(Relation<Entry> relation, Entry e) {
        assert (relation != null) : "relation = null";
        Attribute attr = null;
        if (this.attribute != null && relation.hasAttribute(this.attribute)) {
            attr = relation.getAttribute(this.attribute);
        }
        return this.renderer.getText(attr, e);
    }

    public Comparator<Entry> getComparator(Relation<Entry> relation) {
        return this.compFactory.create(relation);
    }

    public void setMinWidth(int width) {
        this.minWidth = width;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }
}

