/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class Config {
    private static Properties config = null;
    private static final String CONF_FILE = System.getProperty("user.home") + File.separator + ".jrcfviewer";

    private Config() {
    }

    public static Properties getConfig() {
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfig() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(CONF_FILE);
        }
        catch (FileNotFoundException e) {
            System.err.println("No config file found at \"" + CONF_FILE + "\".");
        }
        if (null != fos) {
            try {
                config.store(fos, null);
            }
            catch (IOException e) {
                System.err.println("Error while storing config file \"" + CONF_FILE + "\".");
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    System.err.println("Error while closing config file \"" + CONF_FILE + "\".");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        config = new Properties();
        File f = new File(CONF_FILE);
        boolean configFileExists = false;
        if (!f.exists()) {
            System.out.println("Cannot find the config file. Config file will be created in " + CONF_FILE + ".");
            try {
                configFileExists = f.createNewFile();
            }
            catch (IOException e) {
                System.err.println("Creating the config file \"" + CONF_FILE + "\" failed.");
            }
        } else {
            configFileExists = true;
        }
        if (configFileExists) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(CONF_FILE);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (null != fis) {
                try {
                    config.load(fis);
                }
                catch (IOException e) {
                    System.err.println("Error while parsing config file \"" + CONF_FILE + "\".");
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        System.err.println("Error while closing config file \"" + CONF_FILE + "\".");
                    }
                }
            }
        }
    }
}

