/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.util;

import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcfviewer.util.TokenWrapper;
import de.uni_bremen.st.rcfviewer.util.languages.AbstractLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.conqat.lib.scanner.IToken;

public class FragmentContext {
    public static int defaultContextMargin = 10;
    private Fragment fragment;
    private int contextMargin = defaultContextMargin;
    private List<String> preText = new ArrayList<String>();
    private List<String> text = new ArrayList<String>();
    private List<String> postText = new ArrayList<String>();
    private Map<Integer, TreeMap<Integer, TokenWrapper>> tokens = new TreeMap<Integer, TreeMap<Integer, TokenWrapper>>();
    private AbstractLanguage language;

    public FragmentContext(Fragment fragment) {
        this.fragment = fragment;
        assert (fragment != null);
    }

    public void appendPreText(String line) {
        this.preText.add(line);
    }

    public void appendText(String line) {
        this.text.add(line);
    }

    public void appendPostText(String line) {
        this.postText.add(line);
    }

    public int getContextMargin() {
        return this.contextMargin;
    }

    public List<String> getPreText() {
        return new ArrayList<String>(this.preText);
    }

    public List<String> getText() {
        return new ArrayList<String>(this.text);
    }

    public List<String> getPostText() {
        return new ArrayList<String>(this.postText);
    }

    public File getFile() {
        return this.fragment.getStart().getFile();
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public void setLanguage(AbstractLanguage language) {
        this.language = language;
    }

    public AbstractLanguage getLanguage() {
        return this.language;
    }

    public void addToken(IToken token) {
        String[] lines = token.getText().split("\n");
        int offset = token.getOffset();
        int lineNumber = token.getLineNumber() + this.fragment.getStart().getLine() - Math.min(this.getContextMargin(), this.fragment.getStart().getLine());
        for (String line : lines) {
            TokenWrapper tw = new TokenWrapper(token, offset, lineNumber, line);
            TreeMap<Integer, TokenWrapper> tl = this.tokens.get(lineNumber);
            if (tl == null) {
                tl = new TreeMap();
                this.tokens.put(lineNumber, tl);
            }
            tl.put(offset, tw);
            offset += line.length() + 1;
            ++lineNumber;
        }
    }

    public Map<Integer, TokenWrapper> getTokens(int lineNumber) {
        TreeMap<Integer, TokenWrapper> ret = this.tokens.get(lineNumber);
        if (ret == null) {
            return new TreeMap<Integer, TokenWrapper>();
        }
        return new TreeMap<Integer, TokenWrapper>((SortedMap<Integer, TokenWrapper>)ret);
    }

    public Collection<TokenWrapper> getTokens() {
        int begin = this.fragment.getStart().getLine() - 1;
        int end = this.fragment.getEnd().getLine() + 1;
        LinkedList<TokenWrapper> ret = new LinkedList<TokenWrapper>();
        for (Map.Entry<Integer, TreeMap<Integer, TokenWrapper>> twt : this.tokens.entrySet()) {
            if (twt.getKey() < begin || twt.getKey() > end) continue;
            for (TokenWrapper tw : twt.getValue().values()) {
                ret.add(tw);
            }
        }
        return ret;
    }

    public void resetTokensDiff() {
        for (TreeMap<Integer, TokenWrapper> twt : this.tokens.values()) {
            for (TokenWrapper tw : twt.values()) {
                tw.setDiff(false);
            }
        }
    }
}

