/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.util.columnrenderer;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.schema.AttributeType;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.ColRenderer;
import java.util.List;

public class DefaultColRenderer
implements ColRenderer {
    private String getStringForEntry(Attribute a, Entry e) {
        switch (a.getType()) {
            case STRING: {
                return e.getString(a);
            }
            case INTEGER: {
                return Integer.toString(e.getInt(a));
            }
            case FLOAT: {
                return Float.toString(e.getFloat(a));
            }
            case BOOLEAN: {
                return Boolean.toString(e.getBool(a));
            }
            case REFERENCE: {
                Entry ref = e.getEntry(a.getName());
                return ref.getRelation().getName() + ":" + ref.getId();
            }
        }
        return "#";
    }

    @Override
    public String getText(Attribute a, Entry e) {
        if (a == null) {
            return "?No Attribute?";
        }
        if (!e.isSet(a)) {
            return "-";
        }
        if (a.isList()) {
            List<Object> list = null;
            AttributeType attributeType = a.getType();
            if (null == attributeType) {
                return "?No attribute type?";
            }
            switch (attributeType) {
                case STRING: {
                    list = e.getStringList(a);
                    break;
                }
                case INTEGER: {
                    list = e.getIntList(a);
                    break;
                }
                case FLOAT: {
                    list = e.getFloatList(a);
                    break;
                }
                case BOOLEAN: {
                    list = e.getBoolList(a);
                    break;
                }
                case REFERENCE: {
                    List<Entry> entryList = e.getEntryList(a);
                    int size = entryList.size();
                    if (size > 3) {
                        return "" + size + " Elements";
                    }
                    StringBuilder s = new StringBuilder();
                    for (Entry entry : entryList) {
                        s.append(entry.getRelation().getName()).append(":").append(entry.getId());
                        s.append(",");
                    }
                    return s.substring(0, s.length() > 0 ? s.length() - 1 : 0);
                }
                default: {
                    return "?unsupported attribute type?";
                }
            }
            int size = list.size();
            if (size > 3) {
                return "#" + size;
            }
            StringBuilder s = new StringBuilder();
            for (Object o : list) {
                s.append(o.toString());
                s.append(",");
            }
            return s.substring(0, s.length() > 0 ? s.length() - 1 : 0);
        }
        return this.getStringForEntry(a, e);
    }

    @Override
    public Comparable<?> getCompImage(Attribute a, Entry e) {
        if (a != null) {
            if (e.isSet(a)) {
                switch (a.getType()) {
                    case INTEGER: {
                        return e.getInt(a);
                    }
                    case FLOAT: {
                        return Float.valueOf(e.getFloat(a));
                    }
                }
            } else {
                switch (a.getType()) {
                    case INTEGER: {
                        return 0;
                    }
                    case FLOAT: {
                        return Float.valueOf(0.0f);
                    }
                }
            }
        }
        return this.getText(a, e);
    }
}

