/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.util.columnrenderer;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.schema.AttributeType;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.ColRenderer;
import java.util.List;

public class RefRenderer
implements ColRenderer {
    private String getStringForEntry(Entry e) {
        if (e instanceof File) {
            File file = (File)e;
            return file.getRelativePath();
        }
        if (e instanceof Version) {
            Version version = (Version)e;
            return version.getBasepath();
        }
        return "?Not a predefined Reference Type?";
    }

    @Override
    public String getText(Attribute a, Entry e) {
        if (a == null) {
            return "?No Attribute?";
        }
        if (!e.isSet(a)) {
            return "-";
        }
        if (a.getType() != AttributeType.REFERENCE) {
            return "?No Reference?";
        }
        if (a.isList()) {
            List<Entry> list = e.getEntryList(a);
            int size = list.size();
            if (size > 3) {
                return "" + size + " Files";
            }
            StringBuilder s = new StringBuilder();
            for (Entry f : list) {
                s.append(this.getStringForEntry(f));
                s.append(",");
            }
            return s.substring(0, s.length() > 0 ? s.length() - 1 : 0);
        }
        Entry file = e.getEntry(a);
        return this.getStringForEntry(file);
    }

    @Override
    public Comparable<?> getCompImage(Attribute a, Entry e) {
        return this.getText(a, e);
    }
}

