/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.util.comparatorfactories;

import de.uni_bremen.st.rcf.exceptions.NoSuchAttributeException;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcfviewer.util.columnrenderer.ColRenderer;
import de.uni_bremen.st.rcfviewer.util.comparatorfactories.ComparatorFactory;
import java.util.Comparator;

public class DefaultComparatorFactory
implements ComparatorFactory {
    private String attribute;
    private ColRenderer renderer;

    public DefaultComparatorFactory(String attribute, ColRenderer renderer) {
        assert (renderer != null);
        this.attribute = attribute;
        this.renderer = renderer;
    }

    @Override
    public Comparator<Entry> create(Relation<Entry> relation) {
        assert (relation != null);
        Attribute attr = null;
        try {
            if (this.attribute != null) {
                attr = relation.getAttribute(this.attribute);
            }
            return new DefaultComparator(attr, this.renderer);
        }
        catch (NoSuchAttributeException ex) {
            return new Comparator<Entry>(){

                @Override
                public int compare(Entry o1, Entry o2) {
                    return 0;
                }
            };
        }
    }

    static class DefaultComparator
    implements Comparator<Entry> {
        private Attribute attribute;
        private ColRenderer renderer;

        public DefaultComparator(Attribute attribute, ColRenderer renderer) {
            assert (renderer != null);
            this.attribute = attribute;
            this.renderer = renderer;
        }

        @Override
        public int compare(Entry gt1, Entry gt2) {
            return this.renderer.getCompImage(this.attribute, gt1).compareTo(this.renderer.getCompImage(this.attribute, gt2));
        }
    }
}

