/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.util.languages;

import de.uni_bremen.st.rcfviewer.util.Colors;
import de.uni_bremen.st.rcfviewer.util.languages.Ada;
import de.uni_bremen.st.rcfviewer.util.languages.CPP;
import de.uni_bremen.st.rcfviewer.util.languages.Java;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IToken;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public abstract class AbstractLanguage {
    public abstract ELanguage getScannerLanguage();

    public void chooseStyle(StyleRange sr, Color defaultColor, IToken t) {
        ETokenType type = t.getType();
        if (type.isKeyword()) {
            sr.foreground = Colors.KEYWORD_COLOR;
            sr.fontStyle = 1;
        } else {
            sr.foreground = type.getTokenClass() == ETokenType.ETokenClass.COMMENT ? Colors.COMMENT_COLOR : (type.isLiteral() ? Colors.LITERAL_COLOR : defaultColor);
        }
    }

    public static AbstractLanguage languageFromFileName(String filename) {
        String[] splitted = filename.split("\\.");
        if (splitted.length > 1) {
            String end = splitted[splitted.length - 1];
            if (end.equalsIgnoreCase("java")) {
                return new Java();
            }
            if (end.equalsIgnoreCase("adb") || end.equalsIgnoreCase(".ads")) {
                return new Ada();
            }
            if (end.equalsIgnoreCase("cpp") || end.equalsIgnoreCase("cc") || end.equalsIgnoreCase("c") || end.equalsIgnoreCase("h") || end.equalsIgnoreCase("hpp") || end.equalsIgnoreCase("hh") || end.equalsIgnoreCase("cxx")) {
                return new CPP();
            }
        }
        System.out.println("Could not choose a Language falling back to CPP");
        return new CPP();
    }
}

