/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.util.sourceCode;

import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcfviewer.util.sourceCode.SourceCodeWrapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class SourceCodeCache {
    private static final int CACHE_SIZE = 20;
    private static SourceCodeCache instance = new SourceCodeCache();
    private Map<String, SourceCodeWrapper> cache = new LinkedHashMap<String, SourceCodeWrapper>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SourceCodeWrapper> eldest) {
            return this.size() > 20;
        }
    };

    private SourceCodeCache() {
    }

    public static SourceCodeCache getInstance() {
        return instance;
    }

    public SourceCodeWrapper getSourceCodeWrapper(File file) throws IOException {
        String absolutePath = file.getAbsolutePath();
        SourceCodeWrapper sourceCodeWrapper = this.cache.get(absolutePath);
        if (null == sourceCodeWrapper) {
            sourceCodeWrapper = new SourceCodeWrapper(file);
            this.cache.put(absolutePath, sourceCodeWrapper);
        }
        return sourceCodeWrapper;
    }

    public SourceCodeWrapper getSourceCodeWrapper(Fragment fragment) throws IOException {
        return this.getSourceCodeWrapper(fragment.getStart().getFile());
    }
}

