/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.util.sourceCode;

import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.util.FileVersionHandler;
import de.uni_bremen.st.rcf.util.offsethandling.OffsetCounter;
import de.uni_bremen.st.rcfviewer.util.languages.AbstractLanguage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerException;
import org.conqat.lib.scanner.ScannerFactory;

public class SourceCodeWrapper {
    private static final FileVersionHandler fileVersionHandler = FileVersionHandler.getInstance();
    private final de.uni_bremen.st.rcf.model.File file;
    private final File javaFile;
    private final OffsetCounter offsetCounter;
    private final AbstractLanguage language;
    private final SortedMap<Integer, IToken> tokens;

    public SourceCodeWrapper(de.uni_bremen.st.rcf.model.File file) throws IOException {
        this.file = file;
        String validPath = fileVersionHandler.getLastValidFile(file);
        this.javaFile = new File(validPath);
        this.offsetCounter = new OffsetCounter(new FileReader(validPath));
        this.language = AbstractLanguage.languageFromFileName(validPath);
        this.tokens = this.calculateTokens();
    }

    public String getCode() {
        return this.offsetCounter.getSourceCode();
    }

    public OffsetCounter getOffsetCounter() {
        return this.offsetCounter;
    }

    public de.uni_bremen.st.rcf.model.File getFile() {
        return this.file;
    }

    public List<IToken> getToken(int from, int to) {
        ArrayList<IToken> list = new ArrayList<IToken>(this.tokens.size());
        SortedMap<Integer, IToken> subMap = this.tokens.subMap(from, to + 1);
        for (IToken token : subMap.values()) {
            list.add(token);
        }
        return list;
    }

    public List<IToken> getToken(Fragment fragment) {
        return this.getToken(fragment.getStart().getOffset(), fragment.getEnd().getOffset());
    }

    public List<IToken> getToken(List<Fragment> fragments) {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (Fragment fragment : fragments) {
            if (fragment.getStart().getOffset() < min) {
                min = fragment.getStart().getOffset();
            }
            if (fragment.getEnd().getOffset() <= max) continue;
            max = fragment.getEnd().getOffset();
        }
        return this.getToken(min, max);
    }

    private SortedMap<Integer, IToken> calculateTokens() throws IOException {
        TreeMap<Integer, IToken> map = new TreeMap<Integer, IToken>();
        ILenientScanner scanner = ScannerFactory.newLenientScanner(this.language.getScannerLanguage(), this.javaFile);
        try {
            IToken token;
            while (ETokenType.EOF != (token = scanner.getNextToken()).getType()) {
                map.put(token.getOffset(), token);
            }
        }
        catch (ScannerException e) {
            throw new IOException(e);
        }
        return map;
    }
}

