/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.views;

import de.uni_bremen.st.rcfviewer.controller.EntryInspectorCtrl;
import de.uni_bremen.st.rcfviewer.models.EntryInspectorAttribute;
import de.uni_bremen.st.rcfviewer.models.EntryInspectorModel;
import de.uni_bremen.st.rcfviewer.views.AbstractView;
import de.uni_bremen.st.rcfviewer.views.ViewDisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class EntryInspectorView
extends AbstractView {
    private EntryInspectorCtrl ctrl;
    private EntryInspectorModel model;
    private Composite comp;
    private Button btnPrev;
    private Button btnNext;
    private Link relationLabel;
    private Label idLabel;
    private Composite dataComp;

    public EntryInspectorView(Composite parent, EntryInspectorCtrl ctrl, EntryInspectorModel model) {
        assert (parent != null);
        assert (ctrl != null);
        assert (model != null);
        this.ctrl = ctrl;
        this.model = model;
        this.comp = new Composite(parent, 0);
        this.comp.setLayout((Layout)new FormLayout());
        this.btnPrev = new Button(this.comp, 8);
        this.btnPrev.setText("<");
        Composite header = new Composite(this.comp, 0);
        header.setLayout((Layout)new GridLayout(2, true));
        this.relationLabel = new Link(header, 0);
        this.relationLabel.setText("<a>Relation</a> :");
        this.idLabel = new Label(header, 0);
        this.idLabel.setText("ID");
        this.btnNext = new Button(this.comp, 8);
        this.btnNext.setText(">");
        GridLayout dataLayout = new GridLayout(2, false);
        this.dataComp = new Composite(this.comp, 2048);
        this.dataComp.setLayout((Layout)dataLayout);
        this.relationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.idLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        FormData fdHeader = new FormData();
        fdHeader.bottom = new FormAttachment((Control)this.btnPrev, 0, 1024);
        fdHeader.top = new FormAttachment((Control)this.btnPrev, 0, 128);
        fdHeader.left = new FormAttachment((Control)this.btnPrev, 6);
        fdHeader.right = new FormAttachment((Control)this.btnNext, -6);
        header.setLayoutData((Object)fdHeader);
        FormData fdBtnNext = new FormData();
        fdBtnNext.top = new FormAttachment((Control)this.btnPrev, 0, 128);
        fdBtnNext.right = new FormAttachment(100, -10);
        this.btnNext.setLayoutData((Object)fdBtnNext);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        this.btnPrev.setLayoutData((Object)data);
        FormData fdComposite = new FormData();
        fdComposite.top = new FormAttachment((Control)this.btnPrev, 6);
        fdComposite.bottom = new FormAttachment(100, -10);
        fdComposite.right = new FormAttachment(100, -10);
        fdComposite.left = new FormAttachment((Control)this.btnPrev, 0, 16384);
        this.dataComp.setLayoutData((Object)fdComposite);
        this.btnNext.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                EntryInspectorView.this.next();
            }
        });
        this.btnPrev.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                EntryInspectorView.this.previous();
            }
        });
        this.relationLabel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EntryInspectorView.this.showRelation();
            }
        });
    }

    @Override
    public Control getControl() {
        return this.comp;
    }

    @Override
    public void update() {
        for (Control c : this.dataComp.getChildren()) {
            c.dispose();
        }
        this.comp.pack();
        this.relationLabel.setText(String.format("<a>%s</a> :", this.model.getRelationName()));
        this.idLabel.setText(String.format("%d", this.model.getId()));
        for (final EntryInspectorAttribute a : this.model.getData()) {
            Label label = new Label(this.dataComp, 0);
            label.setAlignment(131072);
            label.setText(a.getName() + " :");
            GridData gdLabel = new GridData();
            gdLabel.horizontalAlignment = 4;
            label.setLayoutData((Object)gdLabel);
            Link value = new Link(this.dataComp, 131076);
            if (a.isReference()) {
                value.setText(String.format("<a>%s</a>", a.getValue()));
                value.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        EntryInspectorCtrl.getInstance().showReference(a.getAttribute(), a.getEntry());
                    }
                });
            } else {
                value.setText(a.getValue());
            }
            GridData gdValue = new GridData();
            gdValue.horizontalAlignment = 4;
            value.setLayoutData((Object)gdValue);
        }
        this.btnPrev.setEnabled(this.model.hasPrevious());
        this.btnNext.setEnabled(this.model.hasNext());
        this.comp.pack();
        this.comp.getParent().pack();
    }

    public static EntryInspectorView create(EntryInspectorCtrl entryInspectorCtrl) {
        final Shell shell = new Shell();
        shell.setText("Entry Inspector");
        shell.setLayout((Layout)new FillLayout());
        EntryInspectorView view = entryInspectorCtrl.makeView((Composite)shell);
        view.addDisposeListener(new ViewDisposeListener(){

            @Override
            public void viewDisposed() {
                shell.dispose();
            }
        });
        shell.setVisible(true);
        return view;
    }

    private void next() {
        this.ctrl.next();
    }

    private void previous() {
        this.ctrl.previous();
    }

    private void showRelation() {
        this.ctrl.showRelation();
    }
}

