/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.views;

import de.uni_bremen.st.rcfviewer.controller.RcfRelationCtrl;
import de.uni_bremen.st.rcfviewer.models.RcfRelationModel;
import de.uni_bremen.st.rcfviewer.util.ColumnInfo;
import de.uni_bremen.st.rcfviewer.views.AbstractView;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RcfRelationView
extends AbstractView {
    private RcfRelationModel model;
    private final RcfRelationCtrl controller;
    private Composite comp;
    private Button btnShowAttribs;
    private Map<String, Button> colBtns;
    private Table table;

    public Table getTable() {
        return this.table;
    }

    public RcfRelationView(Composite parent, RcfRelationModel relModel, RcfRelationCtrl ctrl) {
        assert (parent != null);
        this.model = relModel;
        this.controller = ctrl;
        assert (this.model != null) : "model = null";
        assert (ctrl != null) : "controller = null";
        this.comp = new Composite(parent, 0);
        this.comp.setLayout((Layout)new FormLayout());
        Label label = new Label(this.comp, 0);
        label.setText(this.model.getRelationName());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment(0, 10);
        label.setLayoutData((Object)data);
        this.table = new Table(this.comp, 0x10010800);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RcfRelationView.this.model.setSelection(RcfRelationView.this.table.getSelectionIndex());
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 2) {
                    Point p = new Point(e.x, e.y);
                    TableItem item = RcfRelationView.this.table.getItem(p);
                    if (item != null) {
                        for (int i = 0; i < RcfRelationView.this.table.getColumnCount(); ++i) {
                            if (!item.getBounds(i).contains(p)) continue;
                            RcfRelationView.this.controller.showReference(RcfRelationView.this.table.indexOf(item), i);
                            break;
                        }
                    }
                }
            }
        });
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event e) {
                TableItem item = (TableItem)e.item;
                int idx = RcfRelationView.this.table.indexOf(item);
                item.setText(RcfRelationView.this.model.getData(idx));
            }
        });
        FormData tableData = new FormData();
        tableData.top = new FormAttachment((Control)label, 10);
        tableData.left = new FormAttachment(0, 0);
        tableData.right = new FormAttachment(100, 0);
        tableData.bottom = new FormAttachment(100, 0);
        this.table.setLayoutData((Object)tableData);
        this.btnShowAttribs = new Button(this.comp, 8);
        this.btnShowAttribs.setText("Fields");
        this.btnShowAttribs.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RcfRelationView.this.showColumnDialog();
            }
        });
        FormData btnData = new FormData();
        btnData.top = new FormAttachment(0, 5);
        btnData.right = new FormAttachment(100, 0);
        this.btnShowAttribs.setLayoutData((Object)btnData);
        this.refreshColumns(this.model.getActiveColumns());
    }

    private int toPixel(int width) {
        GC gc = new GC((Drawable)this.table);
        FontMetrics fontMetrics = gc.getFontMetrics();
        return fontMetrics.getAverageCharWidth() * width;
    }

    private void refreshColumns(List<ColumnInfo> columns) {
        for (TableColumn tc : this.table.getColumns()) {
            tc.dispose();
        }
        for (ColumnInfo ci : columns) {
            TableColumn tc = new TableColumn(this.table, 0);
            tc.setText(ci.getLabel());
            tc.setToolTipText(ci.getLabel());
            tc.setWidth(this.toPixel(ci.getLabel().length() + 3));
            tc.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    String colname = ((TableColumn)e.widget).getText();
                    if (colname.equals(RcfRelationView.this.model.getSortColumn())) {
                        RcfRelationView.this.model.setReverseSort(!RcfRelationView.this.model.getReverseSort());
                    } else {
                        RcfRelationView.this.model.setReverseSort(false);
                    }
                    RcfRelationView.this.model.setSortColumn(colname);
                    RcfRelationView.this.controller.update();
                }
            });
        }
    }

    private static boolean deepEquals(List<ColumnInfo> c1, TableColumn[] c2) {
        if (c1.size() != c2.length) {
            return false;
        }
        ListIterator<ColumnInfo> i = c1.listIterator();
        int j = 0;
        while (i.hasNext()) {
            if (i.next().equals(c2[j])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.comp.dispose();
        super.dispose();
    }

    @Override
    public Control getControl() {
        return this.comp;
    }

    public void showColumnDialog() {
        Shell shell = new Shell(this.comp.getDisplay(), 32768);
        shell.setLayout((Layout)new GridLayout(2, false));
        List<ColumnInfo> columns = this.model.getColumns();
        this.colBtns = new TreeMap<String, Button>();
        for (ColumnInfo ci : columns) {
            Button btn = new Button((Composite)shell, 32);
            btn.setText(ci.getLabel());
            btn.setSelection(ci.isActive());
            GridData data = new GridData();
            data.horizontalSpan = 2;
            btn.setLayoutData((Object)data);
            this.colBtns.put(ci.getLabel(), btn);
        }
        Button btnOk = new Button((Composite)shell, 8);
        btnOk.setText("OK");
        btnOk.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                for (Map.Entry e : RcfRelationView.this.colBtns.entrySet()) {
                    RcfRelationView.this.controller.setActive((String)e.getKey(), ((Button)e.getValue()).getSelection());
                }
                RcfRelationView.this.hideColumnDialog(event);
                RcfRelationView.this.update();
            }
        });
        GridData okData = new GridData();
        okData.grabExcessHorizontalSpace = true;
        okData.grabExcessVerticalSpace = true;
        btnOk.setLayoutData((Object)okData);
        Button btnCancel = new Button((Composite)shell, 8);
        btnCancel.setText("Cancel");
        btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RcfRelationView.this.hideColumnDialog(e);
            }
        });
        GridData cancelData = new GridData();
        cancelData.grabExcessHorizontalSpace = true;
        cancelData.grabExcessVerticalSpace = true;
        btnCancel.setLayoutData((Object)cancelData);
        shell.setDefaultButton(btnCancel);
        shell.pack();
        shell.open();
    }

    private void hideColumnDialog(Event e) {
        Shell shell;
        if (e.widget instanceof Button && !(shell = ((Button)e.widget).getShell()).isDisposed()) {
            shell.dispose();
        }
    }

    private void resizeColumns(List<ColumnInfo> columns) {
        ListIterator<ColumnInfo> i = columns.listIterator();
        for (TableColumn tc : this.table.getColumns()) {
            ColumnInfo ci = i.next();
            tc.setWidth(this.toPixel(Math.min(Math.max(ci.getMinWidth(), ci.getPreferredWidth() + 3), ci.getMaxWidth() + 3)));
        }
    }

    @Override
    public void update() {
        if (this.comp.isDisposed()) {
            this.controller.dispose();
        } else {
            List<ColumnInfo> columns = this.model.getActiveColumns();
            if (!RcfRelationView.deepEquals(columns, this.table.getColumns())) {
                this.refreshColumns(columns);
            }
            this.table.setItemCount(this.model.getDataLength());
            this.table.clearAll();
            if (this.model.getDataLength() > 0) {
                this.resizeColumns(columns);
            }
        }
    }
}

