/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.views.cloneview;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcfviewer.util.Diff;
import de.uni_bremen.st.rcfviewer.util.Pair;
import de.uni_bremen.st.rcfviewer.util.sourceCode.SourceCodeCache;
import de.uni_bremen.st.rcfviewer.util.sourceCode.SourceCodeWrapper;
import de.uni_bremen.st.rcfviewer.views.cloneview.Connections;
import de.uni_bremen.st.rcfviewer.views.cloneview.SourceCodeView;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.FileHighlighting;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.HighlightingCalculator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.conqat.lib.scanner.IToken;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CloneView {
    private final SourceCodeCache sourceCodeCache = SourceCodeCache.getInstance();
    private final SashForm sash;
    private final Connections connections;
    private final SourceCodeView left;
    private Fragment lastLeftFragment;
    private final SourceCodeView right;
    private boolean scrollParallel = true;
    private boolean drawOnlyVisibleConnectionEndpoints = true;
    private boolean ctrlPressed = false;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(2, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable);
            t.setPriority(10);
            t.setDaemon(true);
            return t;
        }
    });
    private final HighlightingCalculator leftCalculator = new HighlightingCalculator();
    private final HighlightingCalculator rightCalculator = new HighlightingCalculator();

    public CloneView(Composite parent) {
        this.sash = new SashForm(parent, 65792);
        this.left = new SourceCodeView((Composite)this.sash, this);
        Composite checkParaConnections = new Composite((Composite)this.sash, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginTop = 22;
        checkParaConnections.setLayout((Layout)gridLayout);
        this.connections = new Connections(checkParaConnections, 0);
        this.connections.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.right = new SourceCodeView((Composite)this.sash, this);
        this.sash.setWeights(new int[]{48, 4, 48});
        Display.getCurrent().addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 262144) {
                    CloneView.this.ctrlPressed = true;
                }
            }
        });
        Display.getCurrent().addFilter(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 262144) {
                    CloneView.this.ctrlPressed = false;
                }
            }
        });
    }

    public Fragment getLastLeftFragment() {
        return this.lastLeftFragment;
    }

    public void setLastLeftFragment(Fragment lastLeftFragment) {
        this.lastLeftFragment = lastLeftFragment;
    }

    public void sendScrollEvent(SourceCodeView sourceCodeView, int pixel) {
        if (!this.ctrlPressed && this.scrollParallel) {
            SourceCodeView theOther = this.left;
            if (this.left == sourceCodeView) {
                theOther = this.right;
            }
            theOther.scrollByPixel(pixel);
        }
        this.redrawConnections();
    }

    public void redrawConnections() {
        this.connections.redraw();
    }

    public Control getControl() {
        return this.sash;
    }

    public void dispose() {
        this.sash.dispose();
    }

    public void setRight(Fragment right) {
        this.set(this.lastLeftFragment, right);
    }

    public void set(Fragment left, Fragment right) {
        ArrayList<Fragment> leftFragment = new ArrayList<Fragment>(1);
        leftFragment.add(left);
        ArrayList<Fragment> rightFragment = new ArrayList<Fragment>(1);
        rightFragment.add(right);
        this.set(leftFragment, rightFragment);
    }

    public void set(List<Entry> pairs, Relation<Entry> relationPairs) {
        if (pairs.size() > 0) {
            Attribute leftAttribute = relationPairs.getAttribute("left");
            Attribute rightAttribute = relationPairs.getAttribute("right");
            ArrayList<Fragment> leftFragments = new ArrayList<Fragment>(pairs.size() / 2);
            ArrayList<Fragment> rightFragments = new ArrayList<Fragment>(pairs.size() / 2);
            for (Entry pair : pairs) {
                Fragment f = (Fragment)pair.getEntry(leftAttribute);
                leftFragments.add(f);
                f = (Fragment)pair.getEntry(rightAttribute);
                rightFragments.add(f);
            }
            this.set(leftFragments, rightFragments);
        }
    }

    public boolean isScrollParallel() {
        return this.scrollParallel;
    }

    public void setScrollParallel(boolean scrollParallel) {
        this.scrollParallel = scrollParallel;
    }

    public boolean isDrawOnlyVisibleConnectionEndpoints() {
        return this.drawOnlyVisibleConnectionEndpoints;
    }

    public void setDrawOnlyVisibleConnectionEndpoints(boolean drawOnlyVisibleConnectionEndpoints) {
        this.drawOnlyVisibleConnectionEndpoints = drawOnlyVisibleConnectionEndpoints;
    }

    private void set(List<Fragment> leftFragments, List<Fragment> rightFragments) {
        try {
            SourceCodeWrapper leftWrapper = this.sourceCodeCache.getSourceCodeWrapper(leftFragments.get(0));
            SourceCodeWrapper rightWrapper = this.sourceCodeCache.getSourceCodeWrapper(rightFragments.get(0));
            Pair<Map<Integer, IToken>, Map<Integer, IToken>> diffedTokens = Diff.diff(leftWrapper.getToken(leftFragments), rightWrapper.getToken(rightFragments));
            this.leftCalculator.set(leftFragments, leftWrapper, (Map)diffedTokens.first);
            Future<FileHighlighting> leftFuture = this.threadPool.submit(this.leftCalculator);
            this.rightCalculator.set(rightFragments, rightWrapper, (Map)diffedTokens.second);
            Future<FileHighlighting> rightFuture = this.threadPool.submit(this.rightCalculator);
            FileHighlighting leftHighlightings = leftFuture.get();
            FileHighlighting rightHighlightings = rightFuture.get();
            this.set(this.left, leftHighlightings, leftFragments.get(0).getStart().getOffset());
            this.set(this.right, rightHighlightings, rightFragments.get(0).getStart().getOffset());
            this.connections.set(this.left.getCode(), leftHighlightings.fragmentRanges, this.right.getCode(), rightHighlightings.fragmentRanges);
        }
        catch (Exception e) {
            this.displayFile(this.left, leftFragments.get(0));
            this.displayFile(this.right, rightFragments.get(0));
            this.connections.clear();
        }
    }

    private void set(SourceCodeView sourceCodeView, FileHighlighting highlightings, int offsetViewSpot) throws IOException {
        sourceCodeView.set(highlightings, offsetViewSpot);
    }

    private void displayFile(SourceCodeView sourceCodeView, Fragment fragment) {
        String code;
        try {
            SourceCodeWrapper wrapper = this.sourceCodeCache.getSourceCodeWrapper(fragment);
            code = wrapper.getCode();
        }
        catch (IOException ioe) {
            code = "file not found!";
        }
        sourceCodeView.displayFile(fragment.getStart().getFile().getName(), code);
    }
}

