/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.views.cloneview;

import de.uni_bremen.st.rcfviewer.util.Pair;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.Highlighting;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Connections
extends Canvas {
    private static final int arcWidth = 5;
    private StyledText leftCode;
    private SortedSet<Highlighting> left;
    private StyledText rightCode;
    private SortedSet<Highlighting> right;
    private static final Color WHITE = Display.getCurrent().getSystemColor(1);

    public Connections(Composite composite, int i) {
        super(composite, i);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle client = Connections.this.getClientArea();
                paintEvent.gc.setBackground(WHITE);
                paintEvent.gc.fillRectangle(client);
                if (null != Connections.this.leftCode && null != Connections.this.left && null != Connections.this.rightCode && null != Connections.this.right) {
                    Iterator leftIterator = Connections.this.left.iterator();
                    Iterator rightIterator = Connections.this.right.iterator();
                    while (leftIterator.hasNext() && rightIterator.hasNext()) {
                        Highlighting leftHighlighting = (Highlighting)leftIterator.next();
                        Highlighting rightHighlighting = (Highlighting)rightIterator.next();
                        paintEvent.gc.setForeground(leftHighlighting.color);
                        paintEvent.gc.setBackground(paintEvent.gc.getForeground());
                        Pair leftPositions = Connections.this.calculateStartYAndEndY(Connections.this.leftCode, leftHighlighting);
                        Pair rightPositions = Connections.this.calculateStartYAndEndY(Connections.this.rightCode, rightHighlighting);
                        Connections.this.paintPosition(paintEvent, (Integer)leftPositions.first, (Integer)leftPositions.second, 0, 5);
                        Connections.this.paintPosition(paintEvent, (Integer)rightPositions.first, (Integer)rightPositions.second, client.width - 5, 5);
                        Connections.this.paintConnector(paintEvent, 5, (Integer)leftPositions.first, client.width - 5, (Integer)rightPositions.first);
                        Connections.this.paintConnector(paintEvent, 5, (Integer)leftPositions.second, client.width - 5, (Integer)rightPositions.second);
                    }
                }
            }
        });
    }

    private Pair<Integer, Integer> calculateStartYAndEndY(StyledText code, Highlighting highlighting) {
        int topPixel = code.getTopPixel();
        int lineHeight = code.getLineHeight();
        int startLine = code.getLineAtOffset(highlighting.start);
        int endLine = code.getLineAtOffset(highlighting.end);
        int startY = startLine * lineHeight - topPixel;
        int endY = endLine * lineHeight - topPixel;
        return new Pair<Integer, Integer>(startY, endY);
    }

    private void paintPosition(PaintEvent paintEvent, int startY, int endY, int startArc, int arcWidth) {
        Rectangle r = new Rectangle(startArc, startY, arcWidth, endY - startY);
        paintEvent.gc.fillRectangle(r);
    }

    private void paintConnector(PaintEvent paintEvent, int x1, int y1, int x2, int y2) {
        paintEvent.gc.drawLine(x1, y1, x2, y2);
    }

    public void set(StyledText leftCode, SortedSet<Highlighting> left, StyledText rightCode, SortedSet<Highlighting> right) {
        this.leftCode = leftCode;
        this.left = left;
        this.rightCode = rightCode;
        this.right = right;
        this.redraw();
    }

    public void clear() {
        this.leftCode = null;
        this.left = null;
        this.rightCode = null;
        this.right = null;
        this.redraw();
    }
}

