/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.views.cloneview;

import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.Highlighting;
import java.util.SortedSet;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Overview
extends Canvas {
    private final StyledText code;
    private SortedSet<Highlighting> highlightings;
    private static final Color WHITE = Display.getCurrent().getSystemColor(1);
    private static final Color BLACK = Display.getCurrent().getSystemColor(2);

    public Overview(Composite parent, int mode, StyledText styledText) {
        super(parent, mode);
        this.code = styledText;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle client = Overview.this.getClientArea();
                paintEvent.gc.setBackground(WHITE);
                paintEvent.gc.fillRectangle(0, 0, client.width, client.height);
                int numberOfLines = Overview.this.code.getLineCount();
                if (null != Overview.this.highlightings) {
                    for (Highlighting highlighting : Overview.this.highlightings) {
                        int startLine = Overview.this.code.getLineAtOffset(highlighting.start);
                        int endLine = Overview.this.code.getLineAtOffset(highlighting.end);
                        Color color = highlighting.color;
                        paintEvent.gc.setBackground(color);
                        Rectangle r = new Rectangle(0, startLine * client.height / numberOfLines, client.width, (endLine - startLine + 1) * client.height / numberOfLines);
                        paintEvent.gc.fillRectangle(r);
                    }
                }
                paintEvent.gc.setForeground(BLACK);
                Rectangle r = new Rectangle(0, Overview.this.code.getTopPixel() * client.height / Overview.this.code.getLineHeight() / numberOfLines, client.width - 1, client.height * ((Overview)Overview.this).code.getClientArea().height / Overview.this.code.getLineHeight() / numberOfLines);
                paintEvent.gc.drawRectangle(r);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                double heightOfCode = Overview.this.code.getLineHeight() * Overview.this.code.getLineCount();
                double percentage = (double)mouseEvent.y / (double)Overview.this.getSize().y;
                int topPixelOfCode = (int)Math.round(percentage * heightOfCode);
                Overview.this.code.getVerticalBar().setSelection(topPixelOfCode);
                Overview.this.code.getVerticalBar().notifyListeners(13, null);
            }
        });
    }

    public void set(SortedSet<Highlighting> highlightings) {
        this.highlightings = highlightings;
        this.redraw();
    }

    public void clear() {
        this.highlightings = null;
        this.redraw();
    }
}

