/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.views.cloneview;

import de.uni_bremen.st.rcfviewer.views.cloneview.CloneView;
import de.uni_bremen.st.rcfviewer.views.cloneview.Overview;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.FileHighlighting;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.FontStyle;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.Highlighting;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.HighlightingTreeSet;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.TokenHighlighting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SourceCodeView {
    private final Label label;
    private final StyledText lineNumbers;
    private final Overview overview;
    private final ScrollListener codeScrollListener;
    private final StyledText code;
    private final CloneView cloneView;
    private final SourceCodeView self;

    public SourceCodeView(Composite parent, CloneView cloneView) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        int formDataOffset = 5;
        this.label = this.setupLabel(comp, 5);
        this.lineNumbers = this.setupLineNumbers(comp, 5);
        this.codeScrollListener = new ScrollListener();
        this.code = this.setupCode(comp, 5);
        this.overview = this.setupOverview(comp, 5);
        Font font = new Font((Device)parent.getDisplay(), "Bitstream Vera Sans Mono", 11, 0);
        this.lineNumbers.setFont(font);
        this.code.setFont(font);
        this.cloneView = cloneView;
        this.self = this;
    }

    private Label setupLabel(Composite parent, int formDataOffset) {
        Label label = new Label(parent, 0x1000000);
        label.setText("-");
        FormData labelFormData = new FormData();
        labelFormData.top = new FormAttachment(0, formDataOffset);
        labelFormData.left = new FormAttachment(0, formDataOffset);
        labelFormData.right = new FormAttachment(100, -formDataOffset);
        label.setLayoutData((Object)labelFormData);
        return label;
    }

    private StyledText setupLineNumbers(Composite parent, int formDataOffset) {
        StyledText lineNumbers = new StyledText(parent, 8);
        lineNumbers.setEnabled(false);
        lineNumbers.setBackground(parent.getBackground());
        lineNumbers.setIndent(0);
        FormData lineNumbersFormData = new FormData();
        lineNumbersFormData.left = new FormAttachment(0, formDataOffset);
        lineNumbersFormData.right = new FormAttachment(8, formDataOffset);
        lineNumbersFormData.top = new FormAttachment((Control)this.label, formDataOffset);
        lineNumbersFormData.bottom = new FormAttachment(100, -formDataOffset);
        lineNumbers.setLayoutData((Object)lineNumbersFormData);
        return lineNumbers;
    }

    private StyledText setupCode(Composite parent, int formDataOffset) {
        StyledText code = new StyledText(parent, 776);
        FormData codeFormData = new FormData();
        codeFormData.top = new FormAttachment((Control)this.label, formDataOffset);
        codeFormData.right = new FormAttachment(98, -formDataOffset);
        codeFormData.left = new FormAttachment((Control)this.lineNumbers, formDataOffset);
        codeFormData.bottom = new FormAttachment(100, -formDataOffset);
        code.setLayoutData((Object)codeFormData);
        code.getVerticalBar().addSelectionListener((SelectionListener)this.codeScrollListener);
        code.addSelectionListener((SelectionListener)this.codeScrollListener);
        code.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent extendedModifyEvent) {
                SourceCodeView.this.codeScrollListener.reset();
            }
        });
        return code;
    }

    private Overview setupOverview(Composite parent, int formDataOffset) {
        Overview overview = new Overview(parent, 0, this.code);
        FormData overviewFormData = new FormData();
        overviewFormData.top = new FormAttachment((Control)this.label, formDataOffset);
        overviewFormData.right = new FormAttachment(100, -formDataOffset);
        overviewFormData.left = new FormAttachment((Control)this.code, formDataOffset);
        overviewFormData.bottom = new FormAttachment(100, -formDataOffset);
        overview.setLayoutData(overviewFormData);
        return overview;
    }

    void set(FileHighlighting fileHighlighting, int offsetViewSpot) throws IOException {
        this.displayFile(fileHighlighting.fileName, fileHighlighting.code);
        try {
            this.setBackgroundHighlighting(fileHighlighting.backgroundHighlightings);
            this.setTokenHighlighting(fileHighlighting.tokenHighlightings);
            this.overview.set(fileHighlighting.fragmentRanges);
            this.scrollToOffsetViewSpot(offsetViewSpot);
        }
        catch (IllegalArgumentException e) {
            System.out.println("offsets and sourcecode aren't compatible. Did you modify the file: " + fileHighlighting.fileName + "?");
            throw e;
        }
    }

    private void setBackgroundHighlighting(HighlightingTreeSet<Highlighting> backgroundHighlightings) {
        for (Highlighting highlighting : backgroundHighlightings) {
            int startLine = this.code.getLineAtOffset(highlighting.getStart());
            int endLine = this.code.getLineAtOffset(highlighting.getEnd());
            this.code.setLineBackground(startLine, endLine - startLine + 1, highlighting.color);
        }
    }

    private void setTokenHighlighting(HighlightingTreeSet<TokenHighlighting> tokenHighlightings) {
        StyleRange[] styleRanges = new StyleRange[tokenHighlightings.size()];
        int i = 0;
        for (TokenHighlighting highlighting : tokenHighlightings) {
            int length = highlighting.getEnd() - highlighting.getStart();
            StyleRange styleRange = new StyleRange(highlighting.getStart(), length, highlighting.getForeground(), highlighting.background);
            if (highlighting.fontStyle == FontStyle.BOLD) {
                styleRange.fontStyle = 1;
            }
            styleRanges[i++] = styleRange;
        }
        this.code.setStyleRanges(styleRanges);
    }

    private void setLineNumbers(String s) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(s));
        StringBuilder stringBuilder = new StringBuilder();
        int lineNumber = 1;
        while (null != bufferedReader.readLine()) {
            stringBuilder.append(lineNumber++).append('\n');
        }
        this.lineNumbers.setText(stringBuilder.toString());
    }

    private void scrollToOffsetViewSpot(int offsetViewSpot) {
        this.code.setTopIndex(this.code.getLineAtOffset(offsetViewSpot));
        int currentTopPixel = this.code.getTopPixel();
        this.lineNumbers.setTopPixel(currentTopPixel);
        this.codeScrollListener.setTopPixel(currentTopPixel);
    }

    void scrollByPixel(int pixel) {
        this.code.setTopPixel(this.code.getTopPixel() + pixel);
        int currentTopPixel = this.code.getTopPixel();
        this.lineNumbers.setTopPixel(currentTopPixel);
        this.codeScrollListener.setTopPixel(currentTopPixel);
        this.overview.redraw();
    }

    StyledText getCode() {
        return this.code;
    }

    void displayFile(String label, String code) {
        this.label.setText(label);
        this.code.setText(code);
        this.overview.clear();
        try {
            this.setLineNumbers(code);
        }
        catch (IOException e) {
            this.lineNumbers.setText("");
        }
    }

    private class ScrollListener
    extends SelectionAdapter {
        private int mementoTopPixel = 0;

        private ScrollListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int currentTopPixel = SourceCodeView.this.code.getTopPixel();
            int offset = currentTopPixel - this.mementoTopPixel;
            if (offset != 0) {
                this.mementoTopPixel = currentTopPixel;
                SourceCodeView.this.lineNumbers.setTopPixel(currentTopPixel);
                SourceCodeView.this.overview.redraw();
                SourceCodeView.this.cloneView.sendScrollEvent(SourceCodeView.this.self, offset);
            }
        }

        public void setTopPixel(int topPixel) {
            this.mementoTopPixel = topPixel;
        }

        public void reset() {
            this.setTopPixel(0);
        }
    }
}

