/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.views.cloneview.highlighting;

import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.OffsetPosition;
import org.eclipse.swt.graphics.Color;

public class Highlighting
implements OffsetPosition {
    public final int start;
    public final int end;
    public final Color color;

    public Highlighting(int start, int end, Color color) {
        this.start = start;
        this.end = end;
        this.color = color;
        if (end < start) {
            throw new IllegalArgumentException("end needs to be equals or greater than start");
        }
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public Highlighting copy(int start, int end) {
        return new Highlighting(start, end, this.color);
    }

    public Highlighting copy(Color color) {
        return new Highlighting(this.start, this.end, color);
    }

    @Override
    public int compareTo(OffsetPosition offsetPosition) {
        return this.start - offsetPosition.getStart();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Highlighting) {
            Highlighting highlighting = (Highlighting)obj;
            return this.start == highlighting.start && this.end == highlighting.end && this.color.equals((Object)highlighting.color);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 17;
        int hashMultiplier = 59;
        hashCode = hashCode * hashMultiplier + this.start;
        hashCode = hashCode * hashMultiplier + this.end;
        hashCode = hashCode * hashMultiplier + this.color.hashCode();
        return hashCode;
    }
}

